package core.mobility;

import java.util.List;
import java.util.Map;

import static edu.ucc.utils.TimeConstants.DAY;

class MobilityPredictor {
    private final Map<Integer, List<SpatioTemporalRecord>> mobility;

    public MobilityPredictor(Map<Integer, List<SpatioTemporalRecord>> mobility) {
        this.mobility = mobility;
    }

    /**
     * Very simple prediction feature. It will only iterate on the list of records until we find a spot for the given
     * timestamp.
     *
     * @param ueId      The id of the ue whose mobility will be predicted
     * @param timestamp The time for which we want to find out where the ue is.
     * @return The id of the EdgeServer where the ue is predicted to be. Null if there is no available info.
     */
    public int predictMobilityForUserEquipment(int ueId, double timestamp) {
        final List<SpatioTemporalRecord> spatioTemporalRecords = mobility.get(ueId);
        if (spatioTemporalRecords == null) return -1; // no prediction if there is no info about that UE

        // we assume first day was given to learn, hence we do a modulo
        final double adjustedTimestamp = timestamp % DAY;
        // We will simply find the first record withing values.
        SpatioTemporalRecord target = spatioTemporalRecords.get(0);
        for (SpatioTemporalRecord record : spatioTemporalRecords) {
            // if (record.getLocationFix().getTimestamp() <= timestamp)
            if (record.getLocationFix().getTimestamp() <= adjustedTimestamp)
                target = record;
            else
                break;
        }

        return target.getEdgeServerId();
    }
}
