package core.control;

import core.processingchain.events.SolutionEvent;

public class SystemMessageData extends MessageData {
    private final SolutionEvent solutionEvent;

    public SystemMessageData(long size, SolutionEvent solutionEvent, double timestamp) {
        super(size, timestamp);
        this.solutionEvent = solutionEvent;
    }


    @Override
    public String getDescription() {
        return String.format("System message data for %s", solutionEvent);
    }

    public SolutionEvent getSolutionEvent() {
        return solutionEvent;
    }
}
