package core.control;

import core.Solution;
import core.app.App;
import edu.ucc.core.events.simulationevents.SimulationEvent;

public class AppPendingProcessingEvent extends SimulationEvent {
    private final Solution solution;
    private final App app;

    public AppPendingProcessingEvent(Solution solution, App app, double timestamp) {
        super(timestamp);
        this.solution = solution;
        this.app = app;
    }

    @Override
    public void execute() {
        solution.executePendingDataProcessingForApp(app);
    }
}
