package core.context;

import core.app.App;
import core.processingchain.events.SolutionEvent;
import core.processingchain.events.pool.RequestCompletedEvent;
import edu.ucc.entities.Content;
import edu.ucc.network.devices.Host;

import java.util.ArrayList;
import java.util.List;

public class ContextAPI {
    private final App app;
    private final ContextRepository contextRepository;

    public ContextAPI(App app) {
        this.app = app;
        contextRepository = new ContextRepository();
    }

    public void addContextData(SolutionEvent contextData) {
        contextRepository.addContextData(app, contextData);
    }

    public List<SolutionEvent> getRequestsPerContentAndIntervalAndHost(Content content, double startTime, double endTime, Host host) {
        final List<SolutionEvent> contextForAppAndHost = contextRepository.getContextDataForAppAndHostAndContent(app, host, content);
        List<SolutionEvent> result = new ArrayList<>();
        for (SolutionEvent context : contextForAppAndHost) {
            if (context instanceof RequestCompletedEvent && context.getTimestamp() >= startTime && context.getTimestamp() <= endTime) {
                result.add(context);
            }
        }
        return result;
    }

    public App getApp() {
        return app;
    }
}
