package core.app;

/**
 * Used to specify how the data should be relayed when it is received at an edge server where the app is not running.
 */
public enum DataRelayPolicy {
    RELAY_TO_CLOUD {
        @Override
        public String toString() {
            return "RELAY DATA TO CLOUD";
        }
    }, RELAY_TO_CLOSEST_HOST {
        @Override
        public String toString() {
            return "RELAY DATA TO CLOSEST HOST";
        }
    }, IGNORE {
        @Override
        public String toString() {
            return "DON'T RELAY (DATA IS DISMISSED)";
        }
    }
}
