package workload.requests;

import edu.ucc.entities.File;
import edu.ucc.workload.WorkloadGenerationConstants;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;

/***
 * Simple File Generator.
 * It creates a list of files whose size is bounded.
 */
public class SimpleFileGenerator {
    private final int numOfFiles;
    private final long minFileSize;
    private final long maxFileSize;
    private final String baseURI;

    private final List<File> fileList;
    private final Random randomGenerator;

    public SimpleFileGenerator(String baseURI, int numOfFiles, long minFileSize, long maxFileSize) {
        this.baseURI = baseURI;
        this.numOfFiles = numOfFiles;
        this.minFileSize = minFileSize;
        this.maxFileSize = maxFileSize;
        this.fileList = new ArrayList<>();
        this.randomGenerator = new Random(WorkloadGenerationConstants.RANDOM_SEED);
    }

    public void generateFiles() {
        for (int i = 0; i < numOfFiles; i++) {
            String nameThisFile = createRandomName(i);
            long sizeThisFile = createRandomSize();
            fileList.add(new File(nameThisFile, sizeThisFile));
        }
    }

    public List<File> getGeneratedFiles() {
        return fileList;
    }


//    public String describeFiles() {
    //        StringBuilder listAsString = new StringBuilder();
    //        for (File file : fileList) {
    //            listAsString.append(file.toString()).append("\n");
    //        }
    //        return listAsString.toString();
    //    }

    private long createRandomSize() {
        return randomGenerator.nextInt((int) (maxFileSize - minFileSize) + 1) + minFileSize;
//        return ThreadLocalRandom.current().nextLong(minFileSize, maxFileSize);
//        return 200 * MEGABYTE;
    }

    private String createRandomName(int i) {
        return baseURI + String.format("File%s.html", i);
    }

    public List<File> getFileList() {
        return fileList;
    }
}
