package workload.requests;

public class ContentRequestParameters {
    private final int appId;

    private final String baseURI;
    private final int numFileRequests; // = 15;
    private final int numOfFiles; // = 30;
    private final long minFileSize; // = 16 * KILOBYTE;
    private final long maxFileSize; // = 5 * MEGABYTE; // 2 * MEGABYTE;

    private final int numPullDataRequests;
    private final long minDataSizeInPullDataRequests;
    private final long maxDataSizeInPullDataRequests;

    private final int numPushDataRequests;
    private final long minDataSizeInPushDataRequests;
    private final long maxDataSizeInPushDataRequests;

    private final double requestStartTime;
    private final double requestEndTime;

    public ContentRequestParameters(int appId, String baseURI, int numFileRequests, int numOfFiles, long minFileSize, long maxFileSize,
                                    int numPullDataRequests, long minDataSizeInPullDataRequests, long maxDataSizeInPullDataRequests,
                                    int numPushDataRequests, long minDataSizeInPushDataRequests, long maxDataSizeInPushDataRequests,
                                    double requestStartTime, double requestEndTime) {
        this.appId = appId;
        this.baseURI = baseURI;
        this.numFileRequests = numFileRequests;
        this.numOfFiles = numOfFiles;
        this.minFileSize = minFileSize;
        this.maxFileSize = maxFileSize;

        this.numPullDataRequests = numPullDataRequests;
        this.minDataSizeInPullDataRequests = minDataSizeInPullDataRequests;
        this.maxDataSizeInPullDataRequests = maxDataSizeInPullDataRequests;

        this.numPushDataRequests = numPushDataRequests;
        this.minDataSizeInPushDataRequests = minDataSizeInPushDataRequests;
        this.maxDataSizeInPushDataRequests = maxDataSizeInPushDataRequests;
        this.requestStartTime = requestStartTime;
        this.requestEndTime = requestEndTime;
    }

    public int getAppId() {
        return appId;
    }

    public String getBaseURI() {
        return baseURI;
    }

    public int getNumFileRequests() {
        return numFileRequests;
    }

    public int getNumOfFiles() {
        return numOfFiles;
    }

    public long getMinFileSize() {
        return minFileSize;
    }

    public long getMaxFileSize() {
        return maxFileSize;
    }

    public int getNumPullDataRequests() {
        return numPullDataRequests;
    }

    public long getMinDataSizeInPullDataRequests() {
        return minDataSizeInPullDataRequests;
    }

    public long getMaxDataSizeInPullDataRequests() {
        return maxDataSizeInPullDataRequests;
    }

    public int getNumPushDataRequests() {
        return numPushDataRequests;
    }

    public long getMinDataSizeInPushDataRequests() {
        return minDataSizeInPushDataRequests;
    }

    public long getMaxDataSizeInPushDataRequests() {
        return maxDataSizeInPushDataRequests;
    }

    public double getRequestEndTime() {
        return requestEndTime;
    }

    public double getRequestStartTime() {
        return requestStartTime;
    }
}
