package workload.mobility;

import edu.ucc.network.devices.LocationFix;

import java.util.List;

/***
 * A structure to represent the results of the workload.mobility model simulatior - generation.
 */
public class MobilityTrace {
    private int userEquipmentId;
    private List<LocationFix> locationFixes;

    public MobilityTrace(int userEquipmentId, List<LocationFix> locationFixes) {
        this.userEquipmentId = userEquipmentId;
        this.locationFixes = locationFixes;
    }

    public void addLocationFix(LocationFix fix) {
        locationFixes.add(fix);
    }

    public int getUserEquipmentId() {
        return userEquipmentId;
    }

    public List<LocationFix> getLocationFixes() {
        return locationFixes;
    }
}

