package workload.mobility;

import bonnmotion.MobileNode;
import bonnmotion.Waypoint;
import bonnmotion.models.RandomWaypoint;
import edu.ucc.network.devices.LocationFix;

import java.util.ArrayList;
import java.util.List;

/***
 * Utility class that extracts the list of MobilityTrace from the objects produced by BonnMotion code
 */
public class MobilityMapper {
    private final RandomWaypoint rwp;

    public MobilityMapper(RandomWaypoint randomWaypoint) {
        this.rwp = randomWaypoint;
    }

    /***
     * Transforms the results from the BonnMotion workload.mobility model to the expected structure in this project
     * @return A list of {@link MobilityTrace} for each of the mobile nodes (UEs) in the workload.mobility model results.
     */
    public List<MobilityTrace> transformToTraces() {
        final ArrayList<MobilityTrace> mobilityTraces = new ArrayList<>();
        if (this.rwp == null) {
            return mobilityTraces;
        }

        final MobileNode[] nodes = rwp.getScenarioParameters().nodes;
        for (int userId = 0; userId < nodes.length; userId++) {
            List<LocationFix> fixesThisHost = new ArrayList<>();
            MobileNode node = nodes[userId];
            for (int j = 0; j < node.getNumWaypoints(); j++) {
                LocationFix fix = transformFromWaypoint(node.getWaypoint(j));
                fixesThisHost.add(fix);
            }
            mobilityTraces.add(new MobilityTrace(userId, fixesThisHost));
        }

        return mobilityTraces;
    }

    public static LocationFix transformFromWaypoint(Waypoint waypoint) {
        double latitude = waypoint.pos.x;
        double longitude = waypoint.pos.y;
        double timestamp = waypoint.time;

        return new LocationFix(latitude, longitude, timestamp);
    }

}
