package utils;

import edu.ucc.core.transport.links.GroupedLink;
import edu.ucc.graphic.ScenarioVisualization;
import edu.ucc.network.architecture.ArchitectureParameters;
import edu.ucc.network.devices.BaseStation;
import edu.ucc.network.devices.Host;
import edu.ucc.network.devices.NetworkArchitecture;
import workload.mobility.MobilityParameters;

import java.util.List;
import java.util.Random;

import static utils.ScenarioConstants.*;

public class Utils {

    public static ArchitectureParameters createGenericArchitectureParameters() {
        return new ArchitectureParameters(
                BS_RANGE,
                MAP_WIDTH, MAP_HEIGHT,
                TOTAL_UPLINK_BW_FOR_CLOUD_CHILDREN, TOTAL_DOWNLINK_BW_FOR_CLOUD_CHILDREN,
                TOTAL_UPLINK_BW_FOR_ES_CHILDREN, TOTAL_DOWNLINK_BW_FOR_ES_CHILDREN, TOTAL_BW_FOR_ES_SIBLINGS,
                TOTAL_UPLINK_BW_FOR_BS_CHILDREN, TOTAL_DOWNLINK_BW_FOR_BS_CHILDREN,
                NUM_EDGE_SERVERS, STORAGE_PER_EDGE_SERVER,
                NUM_USER_EQUIPMENTS, MTU);
    }

    public static MobilityParameters createGenericMobilityParameters() {
        return new MobilityParameters(BS_RANGE, MAP_WIDTH, MAP_HEIGHT, NUM_EDGE_SERVERS,
                NUM_USER_EQUIPMENTS, TRAJECTORY_TIME, MIN_SPEED, MAX_SPEED, MAX_PAUSE);
    }

    public static void showWindow(NetworkArchitecture networkArchitecture, ArchitectureParameters architectureParameters) {
        ScenarioVisualization sv = new ScenarioVisualization("Scenario Visualization", networkArchitecture, architectureParameters);
        sv.drawArchitecture();
    }

    public static void ensureArchitectureBandwidth(NetworkArchitecture networkArchitecture) {
        // Alright, this says that it is working, so noting else to do it seems.
        final List<BaseStation> baseStations = networkArchitecture.getBaseStations();
        for (BaseStation bs : baseStations) {
            final double totalDownlinkBwForUEs = bs.getTotalDownlinkBwForChildren();
            final double totalUplinkBwForUEs = bs.getTotalUplinkBwForChildren();
            final List<Host> ues = bs.getChildrenUnits();
            double accumulatedDownlinkBwFromParent = 0.;
            double accumulatedUplinkFromChildren = 0;
            if (!ues.isEmpty()) {
                double prevDownlinkBw = ues.get(0).getGroupedLinkToParent().getTotalBandwidthProvidedByMe(bs);
                double prevUplinkBw = ues.get(0).getGroupedLinkToParent().getTotalBandwidthProvidedByMe(ues.get(0));
                //            System.out.println(String.format("quick calculation %s * %s = %s", prevDownlinkBw, ues.size(), prevDownlinkBw * ues.size()));
                for (Host ue : ues) {
                    final GroupedLink groupedLinkToParent = ue.getGroupedLinkToParent();
                    final double bwFromBs = groupedLinkToParent.getTotalBandwidthProvidedByMe(bs);
                    accumulatedDownlinkBwFromParent += bwFromBs;

                    final double bwFromUe = groupedLinkToParent.getTotalBandwidthProvidedByMe(ue);
                    accumulatedUplinkFromChildren += bwFromUe;

                    if (prevDownlinkBw != bwFromBs) {
                        System.out.printf("Not the same downlink bw!! %s%n", prevDownlinkBw - bwFromBs);
                    }
                    if (prevUplinkBw != bwFromUe) {
                        System.out.printf("Not the same uplink bw!! %s%n", prevUplinkBw - bwFromUe);
                    }
                    prevDownlinkBw = bwFromBs;
                    prevUplinkBw = bwFromUe;
                }
            }
            System.out.printf("Bs %s registered downlink bw for ues %s, actual is %s%n", bs.getId(),
                    totalDownlinkBwForUEs, accumulatedDownlinkBwFromParent);
            System.out.printf("Bs %s registered uplink bw for ues %s, actual is %s%n", bs.getId(),
                    totalUplinkBwForUEs, accumulatedUplinkFromChildren);
        }
    }

    public static double getNumberBetweenInterval(double min, double max, Random randomForTime) {
        return min + randomForTime.nextInt((int) (max - min + 1));
    }
}
