package utils;

import edu.ucc.utils.TimeConstants;
import edu.ucc.utils.TransmissionConstants;

import static edu.ucc.utils.FileConstants.TERABYTE;

public class ScenarioConstants {
    public static final double BS_RANGE = 1.8 * TransmissionConstants.KILOMETER;
    public static final double MAP_WIDTH = 10 * TransmissionConstants.KILOMETER;
    public static final double MAP_HEIGHT = 10 * TransmissionConstants.KILOMETER;
    public static final double TOTAL_UPLINK_BW_FOR_CLOUD_CHILDREN = 1 * TransmissionConstants.GBPS;
    public static final double TOTAL_DOWNLINK_BW_FOR_CLOUD_CHILDREN = 1 * TransmissionConstants.GBPS;//GBPS;
    public static final double TOTAL_UPLINK_BW_FOR_ES_CHILDREN = 1 * TransmissionConstants.GBPS;// 512 * MBPS;
    public static final double TOTAL_DOWNLINK_BW_FOR_ES_CHILDREN = 1 * TransmissionConstants.GBPS; // 512 * MBPS;
    public static final double TOTAL_BW_FOR_ES_SIBLINGS = 512 * TransmissionConstants.MBPS;
    public static final double TOTAL_UPLINK_BW_FOR_BS_CHILDREN = 256 * TransmissionConstants.MBPS; // 128 * MBPS;
    public static final double TOTAL_DOWNLINK_BW_FOR_BS_CHILDREN = 256 * TransmissionConstants.MBPS; // 128 * MBPS;
    public static final int NUM_EDGE_SERVERS = 2;
    public static final long STORAGE_PER_EDGE_SERVER = 10 * TERABYTE;
    public static final int NUM_USER_EQUIPMENTS = 300;
    public static final int MTU = TransmissionConstants.CHUNK_SIZE;

    public static final double TRAJECTORY_TIME = 12 * TimeConstants.HOUR;
    public static final double MIN_SPEED = 1.0;
    public static final double MAX_SPEED = 3.0;
    public static final double MAX_PAUSE = 30 * TimeConstants.MINUTE;
}
