package utils;

import edu.ucc.network.architecture.TopologyMakerLayers;
import edu.ucc.network.architecture.TopologyMakerMesh;
import edu.ucc.network.devices.Location;

import java.util.List;

public class CreatingTopology {
    public static void main(String[] args) {
        //        makeTopologyCircles();
        System.out.println();
        System.out.println();
        makeTopologyMesh();
    }

    private static void makeTopologyMesh() {
        TopologyMakerMesh topologyMakerMesh = new TopologyMakerMesh(5, 5, 50);
        final List<List<Location>> locationsForBSs = topologyMakerMesh.createLocationsForBSs();
        for (int column = 0; column < locationsForBSs.size(); column++) {
            List<Location> bssInColumn = locationsForBSs.get(column);
            System.out.println(String.format("For column %s there are %s rows", column, bssInColumn.size()));
            for (int row = 0; row < bssInColumn.size(); row++) {
                Location location = bssInColumn.get(row);
                System.out.println(String.format("%s: %s", row, location.toString()));
            }
        }
    }

    private static void makeTopologyCircles() {
        TopologyMakerLayers topologyMakerLayers = new TopologyMakerLayers(6, 50);
        final List<List<Location>> locationsForBSs = topologyMakerLayers.createLocationsForBSs();
        int i = 0;
        for (List<Location> bssInLayer : locationsForBSs) {
            System.out.println(String.format("For layer %s there are %s BSs", i++, bssInLayer.size()));
            int j = 0;
            for (Location location : bssInLayer) {
                System.out.println(String.format("%s: %s", j++, location.toString()));
            }
        }
    }
}
