package sampleapps.platerecognition;

import core.processingchain.events.ApplicationEvent;
import core.processingchain.events.EventData;
import core.processingchain.preprocessors.PPOutcome;
import edu.ucc.core.events.simulationevents.ContentReceivedEvent;
import edu.ucc.entities.Data;
import edu.ucc.network.devices.Host;

public class PlateRecognitionEvent extends ApplicationEvent {
    private final String detectedCarPlateNumber;

    public PlateRecognitionEvent(int appId, Host detectingHost, PPOutcome ppOutcome,
                                 EventMetadataPlateRecognition eventMetadata, double timestamp,
                                 String detectedCarPlateNumber) {
        super(appId, "PlateRecognitionEvent", detectingHost, ppOutcome, eventMetadata, timestamp, null);
        this.detectedCarPlateNumber = detectedCarPlateNumber;
        final ContentReceivedEvent testbedEvent = (ContentReceivedEvent) ppOutcome.getObservableTestbedEvent();
        final Data referredContent = (Data) testbedEvent.getReferredContent();

        EventData data = new EventData(toString().length() * 8, this, referredContent.getURI());
        this.setReferredContent(data);
    }

    public String getDetectedCarPlateNumber() {
        return detectedCarPlateNumber;
    }

    @Override
    public String toString() {
        return String.format("PlateRecognitionEvent (plate number is %s, detection at %s %s @ %s)",
                detectedCarPlateNumber,
                detectingHost.getTypeAsString(),
                detectingHost.getId(),
                timestamp
        );
    }
}
