package sampleapps.platerecognition;

import core.processingchain.metadata.pool.SolutionEventMetadata;
import edu.ucc.core.events.simulationevents.ObservableTestbedEvent;
import edu.ucc.network.devices.Location;

public class EventMetadataPlateRecognition extends SolutionEventMetadata {
    private final int height;
    private final int width;
    private final float resolution;
    private final double timestamp;
    private final Location location;

    public EventMetadataPlateRecognition(int appId, ObservableTestbedEvent observableTestbedEvent, int height, int width,
                                         float resolution, double timestamp, Location location) {
        super(appId, observableTestbedEvent);
        this.height = height;
        this.width = width;
        this.resolution = resolution;
        this.timestamp = timestamp;
        this.location = location;
    }

    public int getHeight() {
        return height;
    }

    public int getWidth() {
        return width;
    }

    public float getResolution() {
        return resolution;
    }

    public double getTimestamp() {
        return timestamp;
    }

    public Location getLocation() {
        return location;
    }
}
