package sampleapps.platerecognition;

import core.processingchain.metadata.extractor.MetadataExtractor;
import core.processingchain.metadata.pool.SolutionEventMetadata;
import edu.ucc.core.events.simulationevents.ObservableTestbedEvent;

public class EventMetadataExtractorPlateRecognition extends MetadataExtractor<PlateRecognitionEvent> {

    @Override
    public SolutionEventMetadata extractMetadata(PlateRecognitionEvent entity) {
        PPOutcomePlateRecognition ppOutcome = (PPOutcomePlateRecognition) entity.getPpOutcome();
        ContentMetadataPlateRecognition contentMetadata = (ContentMetadataPlateRecognition) ppOutcome.getTestbedEventMetadata();
        final ObservableTestbedEvent originalEvent = entity.getTestbedEvent();

        return new EventMetadataPlateRecognition(
                entity.getAppId(),
                originalEvent,
                contentMetadata.getHeight(),
                contentMetadata.getWidth(),
                contentMetadata.getResolution(),
                contentMetadata.getTimestamp(),
                contentMetadata.getLocation()
        );
    }
}
