package sampleapps.platerecognition;

import core.processingchain.metadata.pool.ContentMetadata;
import edu.ucc.network.devices.Location;

public class ContentMetadataPlateRecognition extends ContentMetadata {
    private final int height;
    private final int width;
    private final float resolution;
    private final double timestamp;
    private final Location location;

    protected ContentMetadataPlateRecognition(int appId, CameraData referredContent, int height, int width,
                                              float resolution, double timestamp, Location location) {
        super(appId, referredContent);
        this.height = height;
        this.width = width;
        this.resolution = resolution;
        this.timestamp = timestamp;
        this.location = location;
    }

    public int getHeight() {
        return height;
    }

    public int getWidth() {
        return width;
    }

    public float getResolution() {
        return resolution;
    }

    public double getTimestamp() {
        return timestamp;
    }

    public Location getLocation() {
        return location;
    }

    @Override
    public CameraData getReferredContent() {
        return (CameraData) super.getReferredContent();
    }
}
