package sampleapps.platerecognition;

import core.processingchain.metadata.extractor.MetadataExtractor;
import core.processingchain.metadata.pool.BaseMetadata;
import edu.ucc.core.events.simulationevents.ContentReceivedEvent;
import edu.ucc.network.devices.Host;

public class ContentMetadataExtractorPlateRecognition extends MetadataExtractor<ContentReceivedEvent> {
    @Override
    public BaseMetadata extractMetadata(ContentReceivedEvent contentReceivedEvent) {
        CameraData cameraData = (CameraData) contentReceivedEvent.getReferredContent();
        Host host = contentReceivedEvent.getEventDestinationHost();
        return new ContentMetadataPlateRecognition(
                contentReceivedEvent.getAppId(),
                cameraData,
                cameraData.getHeight(),
                cameraData.getWidth(),
                cameraData.getResolution(),
                cameraData.getTimestamp(),
                host.getLocation()
        );
    }
}
