package integrationtests.tests.sysloaders;

import edu.ucc.core.events.simulationevents.HandoverEvent;
import edu.ucc.entities.File;
import edu.ucc.network.devices.NetworkArchitecture;
import edu.ucc.workload.Workload;

import java.util.List;

public interface ICustomWorkloadGenerator {
    /**
     * Helps to define a custom workload according to specified parameters. Internally, you use the workload reference
     * to modify the list of workload events.
     * @param networkArchitecture A reference to the network architecture, to access servers, devices, etc.
     * @param workload A reference to the workload list. Modifications on this reference will be seen by the simulator.
     * @param mobilityEvents The list of mobility events defined. I presume modifying the list will also affect the simulator.
     * @param generatedFiles The list of generated file to produce workloads.
     */
    void generateRequestsForWorkload(NetworkArchitecture networkArchitecture,
                                     Workload workload,
                                     List<HandoverEvent> mobilityEvents,
                                     List<File> generatedFiles);
}
