package integrationtests.tests.sysloaders;

import edu.ucc.core.events.simulationevents.HandoverEvent;
import edu.ucc.network.architecture.ArchitectureParameters;
import edu.ucc.workload.Workload;
import loader.AbstractSystemLoader;
import workload.mobility.MobilityParameters;
import workload.requests.ContentRequestParameters;

import java.util.List;
import java.util.Map;

public class CustomWorkloadSystemLoader extends AbstractSystemLoader {
    private final ICustomWorkloadGenerator customWorkloadGenerator;

    public CustomWorkloadSystemLoader(ArchitectureParameters architectureParameters,
                                      MobilityParameters mobilityParameters,
                                      Map<Integer, ContentRequestParameters> contentParametersPerApp,
                                      ICustomWorkloadGenerator customWorkloadGenerator) {
        super(architectureParameters, mobilityParameters, contentParametersPerApp);
        this.customWorkloadGenerator = customWorkloadGenerator;
    }

    @Override
    public void loadSystem() {
        generateArchitecture();
        generateMobility();
        setInitialUserEquipmentsLocation();
        linkUserEquipmentsWithBaseStations();
        createRoutingTable();
        generateRequests();
        loadWorkloadEvents();
    }

    @Override
    protected void loadWorkloadEvents() {
        this.workload = new Workload();
        final List<HandoverEvent> mobilityEvents = mobilityGenerator.getMobilityEvents();
        workload.setMobilityEvents(mobilityEvents);
        customWorkloadGenerator.generateRequestsForWorkload(networkArchitecture, workload, mobilityEvents, generatedFiles);
        workload.setInitialMobilityEvents(mobilityGenerator.getInitialEnterEvents());
    }
}
