package integrationtests.tests;

import core.Solution;
import core.app.App;
import edu.ucc.core.Simulation;
import edu.ucc.network.architecture.ArchitectureParameters;
import edu.ucc.utils.Logging;
import integrationtests.tests.sysloaders.CustomWorkloadSystemLoader;
import integrationtests.tests.sysloaders.ICustomWorkloadGenerator;
import integrationtests.tests.sysloaders.WorkloadGeneratorFactory;
import loader.AbstractSystemLoader;
import org.junit.jupiter.api.Test;
import workload.mobility.MobilityParameters;
import workload.requests.ContentRequestParameters;

import java.util.HashMap;
import java.util.Map;

import static edu.ucc.utils.FileConstants.GIGABYTE;
import static edu.ucc.utils.FileConstants.MEGABYTE;
import static utils.ScenarioConstants.TRAJECTORY_TIME;
import static utils.Utils.createGenericArchitectureParameters;
import static utils.Utils.createGenericMobilityParameters;

public class ScenarioExploringDirectEdgeServerPrefetchingTest {

    @Test
    void executeTestDirectEdgeServerPrefetching() {
        final long totalSpace = 10 * 10 * GIGABYTE;
        App app = new App(1, "app1", "www.app1.com/", totalSpace);

        // final Simulation simulation = executeScenario(app, WorkloadGeneratorFactory.workloadHighPopularityDownlinkForControlMessagesScenario());
        final Solution solution = executeScenario(app, WorkloadGeneratorFactory.workloadForTestingDirectEdgeServerPrefetching());

        final App appAtCloud = solution.getAppAtCloud(1);
        final int prefetchedFileSize = MEGABYTE * 100;

        final App appAtEdgeServer = solution.getAppAtEdgeServer(1, 0);
        final App appAtEdgeServer2 = solution.getAppAtEdgeServer(1, 1);

        // The workload says to prefetch the file to two edge servers, so...
        assert appAtCloud.getAvailableSpace() == totalSpace - (prefetchedFileSize * 2);
        assert appAtEdgeServer.getAvailableSpace() == totalSpace - (prefetchedFileSize * 2);
        assert appAtEdgeServer2.getAvailableSpace() == totalSpace - (prefetchedFileSize * 2);

    }

    private Solution executeScenario(App app, ICustomWorkloadGenerator workloadGenerator) {
        ArchitectureParameters architectureParameters = createGenericArchitectureParameters();
        architectureParameters.setNumUserEquipments(3);

        MobilityParameters mobilityParameters = createGenericMobilityParameters();
        mobilityParameters.setNumUserEquipments(3);

        final ContentRequestParameters contentRequestParametersForAppDownlink = createContentParametersForAppDownlink(mobilityParameters.getTrajectoryTime());

        Map<Integer, ContentRequestParameters> parametersPerApp = new HashMap<>();
        parametersPerApp.put(1, contentRequestParametersForAppDownlink);

        AbstractSystemLoader systemLoader = new CustomWorkloadSystemLoader(architectureParameters, mobilityParameters, parametersPerApp, workloadGenerator);

        systemLoader.loadSystem();
        final Solution solution = new Solution(systemLoader.getNetworkArchitecture());

        solution.registerApp(app);

        Logging.configureLogging(Logging.WARNING | Logging.CONTENT_RECEIVED | Logging.INFO | Logging.PREFETCH_FILE_REQUEST | Logging.DEBUG);
        final Simulation simulation = Simulation.getInstance();

        simulation.init(systemLoader.getNetworkArchitecture(), systemLoader.getWorkload(), solution, TRAJECTORY_TIME);
        simulation.startSimulation();
        simulation.restart();
        return solution;
    }

    private ContentRequestParameters createContentParametersForAppDownlink(double requestEndTime) {
        // This is for pull workload.requests
        final int numFileRequests = 1;
        final int numOfFiles = 2;
        final long minFileSize = 10 * MEGABYTE;
        final long maxFileSize = 10 * MEGABYTE; // 2 * MEGABYTE;

        final int numPullDataRequests = 0;

        // This is for push workload.requests
        final int numPushDataRequests = 0;
        final long minDataSizeInPushDataRequests = 0;
        final long maxDataSizeInPushDataRequests = 0;
        return new ContentRequestParameters(1,
                "www.app1.com/",
                numFileRequests,
                numOfFiles,
                minFileSize,
                maxFileSize,
                numPullDataRequests,
                0,
                0,
                numPushDataRequests,
                minDataSizeInPushDataRequests,
                maxDataSizeInPushDataRequests,
                0.0, requestEndTime);
    }
}
