/*
 * Decompiled with CFR 0.152.
 */
package bonnmotion.models;

import bonnmotion.MobileNode;
import bonnmotion.ModuleInfo;
import bonnmotion.Position;
import bonnmotion.RandomSpeedBase;
import bonnmotion.Scenario;
import bonnmotion.ScenarioLinkException;
import bonnmotion.Waypoint;
import java.io.FileNotFoundException;
import java.io.IOException;

public class RandomWaypoint
extends RandomSpeedBase {
    private static ModuleInfo info = new ModuleInfo("RandomWaypoint");
    protected int dim = 4;
    private double meshNodeDistance = -1.0;

    public static ModuleInfo getInfo() {
        return info;
    }

    public RandomWaypoint(int nodes, double x, double y, double z, double duration, double ignore, long randomSeed, double minspeed, double maxspeed, double maxpause, int dim) {
        super(nodes, x, y, z, duration, ignore, randomSeed, minspeed, maxspeed, maxpause);
        this.dim = dim;
        this.generate();
    }

    public RandomWaypoint(String[] args) {
        this.go(args);
    }

    @Override
    public void go(String[] args) {
        super.go(args);
        this.generate();
    }

    public RandomWaypoint(String[] args, Scenario _pre, Integer _transitionMode) {
        this.predecessorScenario = _pre;
        this.transitionMode = _transitionMode;
        this.isTransition = true;
        this.go(args);
    }

    public void generate() {
        this.preGeneration();
        for (int i = 0; i < this.parameterData.nodes.length; ++i) {
            this.parameterData.nodes[i] = new MobileNode();
            double t = 0.0;
            Position src = null;
            if (this.isTransition) {
                try {
                    Waypoint lastW = this.transition(this.predecessorScenario, this.transitionMode, i);
                    src = lastW.pos;
                    t = lastW.time;
                }
                catch (ScenarioLinkException e) {
                    e.printStackTrace();
                }
            } else {
                src = this.randomNextPosition();
            }
            while (t < this.parameterData.duration) {
                Position dst;
                if (!this.parameterData.nodes[i].add(t, src)) {
                    throw new RuntimeException(RandomWaypoint.getInfo().name + ".go: error while adding waypoint (1)");
                }
                block1 : switch (this.dim) {
                    case 1: {
                        dst = this.randomNextPosition(-1.0, src.y, -1.0);
                        break;
                    }
                    case 2: {
                        switch ((int)(this.randomNextDouble() * 2.0)) {
                            case 0: {
                                dst = this.randomNextPosition(-1.0, src.y, src.z);
                                break block1;
                            }
                            case 1: {
                                dst = this.randomNextPosition(src.x, -1.0, src.z);
                                break block1;
                            }
                        }
                        throw new RuntimeException(RandomWaypoint.getInfo().name + ".go: This is impossible - how can (int)(randomNextDouble() * 2.0) be something other than 0 or 1?!");
                    }
                    case 3: {
                        dst = this.randomNextPosition();
                        break;
                    }
                    case 4: {
                        switch ((int)(this.randomNextDouble() * 3.0)) {
                            case 0: {
                                dst = this.randomNextPosition(-1.0, src.y, src.z);
                                break block1;
                            }
                            case 1: {
                                dst = this.randomNextPosition(src.x, -1.0, src.z);
                                break block1;
                            }
                            case 2: {
                                dst = this.randomNextPosition(src.x, src.y, -1.0);
                                break block1;
                            }
                        }
                        throw new RuntimeException(RandomWaypoint.getInfo().name + ".go: This is impossible - how can (int)(randomNextDouble() * 3.0) be something other than 0, 1 or 2?!");
                    }
                    case 5: {
                        dst = this.randomNextPosition();
                        break;
                    }
                    default: {
                        throw new RuntimeException(RandomWaypoint.getInfo().name + ".go: dimension may only be of value 1, 2, 3, 4 or 5.");
                    }
                }
                double speed = (this.maxspeed - this.minspeed) * this.randomNextDouble() + this.minspeed;
                double dist = src.distance(dst);
                double time = dist / speed;
                if (!this.parameterData.nodes[i].add(t += time, dst)) {
                    throw new RuntimeException(RandomWaypoint.getInfo().name + ".go: error while adding waypoint (2)");
                }
                if (t < this.parameterData.duration && this.maxpause > 0.0) {
                    double pause = this.maxpause * this.randomNextDouble();
                    t += pause;
                }
                src = dst;
            }
        }
        this.postGeneration();
    }

    @Override
    protected boolean parseArg(String key, String value) {
        if (key.equals("dim")) {
            this.dim = Integer.parseInt(value);
            return true;
        }
        return super.parseArg(key, value);
    }

    @Override
    protected boolean parseArg(char key, String val) {
        switch (key) {
            case 'o': {
                this.dim = Integer.parseInt(val);
                if (this.dim < 1 || this.dim > 5) {
                    System.out.println("dimension must be between 1 and 5");
                    System.exit(0);
                }
                if (this.parameterData.aFieldParams != null && this.dim != 5) {
                    System.out.println("warning: attractor field not used if dim != 3 (2D) OR dim != 5 (3D");
                }
                return true;
            }
            case 'm': {
                this.meshNodeDistance = Double.parseDouble(val);
                return true;
            }
        }
        return super.parseArg(key, val);
    }

    public static void printHelp() {
        System.out.println(RandomWaypoint.getInfo().toDetailString());
        RandomSpeedBase.printHelp();
        System.out.println(RandomWaypoint.getInfo().name + ":");
        System.out.println("\t-o <dimension: 1: x only, 2: x or y, 3: x and y, 4: x or y or z, 5: x and y and z>");
    }

    @Override
    protected void postGeneration() {
        for (int i = 0; i < this.parameterData.nodes.length; ++i) {
            Waypoint l = this.parameterData.nodes[i].getLastWaypoint();
            if (!(l.time > this.parameterData.duration)) continue;
            Position p = this.parameterData.nodes[i].positionAt(this.parameterData.duration);
            this.parameterData.nodes[i].removeLastElement();
            this.parameterData.nodes[i].add(this.parameterData.duration, p);
        }
        if (this.meshNodeDistance > 0.0) {
            this.addMeshNodes();
        }
        super.postGeneration();
    }

    private void addMeshNodes() {
        int i;
        int numMeshX = (int)Math.floor(this.parameterData.x / this.meshNodeDistance);
        int numMeshY = (int)Math.floor(this.parameterData.y / this.meshNodeDistance);
        int numMeshZ = (int)Math.floor(this.parameterData.z / this.meshNodeDistance);
        int numMeshNodes = numMeshX * numMeshY * numMeshZ;
        System.out.println("Adding a grid of " + numMeshNodes + " static mesh nodes...");
        MobileNode[] nodeNew = new MobileNode[this.parameterData.nodes.length + numMeshNodes];
        for (i = 0; i < this.parameterData.nodes.length; ++i) {
            nodeNew[i] = this.parameterData.nodes[i];
        }
        for (i = 0; i < numMeshNodes; ++i) {
            nodeNew[this.parameterData.nodes.length + i] = new MobileNode();
        }
        for (int j = 0; j < numMeshY; ++j) {
            for (int i2 = 0; i2 < numMeshX; ++i2) {
                nodeNew[this.parameterData.nodes.length + j * numMeshX + i2].add(0.0, new Position((double)(i2 + 1) * this.meshNodeDistance, (double)(j + 1) * this.meshNodeDistance, (double)((i2 + 1) * (j + 1)) * this.meshNodeDistance));
            }
        }
        this.parameterData.nodes = nodeNew;
    }

    @Override
    public void write(String _name) throws FileNotFoundException, IOException {
        String[] p = new String[]{"dim=" + this.dim};
        super.write(_name, p);
    }

    static {
        RandomWaypoint.info.description = "Application to construct RandomWaypoint (2D/3D) mobility scenarios";
        RandomWaypoint.info.major = 1;
        RandomWaypoint.info.minor = 0;
        RandomWaypoint.info.revision = ModuleInfo.getSVNRevisionStringValue("$LastChangedRevision: 650 $");
        RandomWaypoint.info.contacts.add("bonnmotion@lists.iai.uni-bonn.de");
        RandomWaypoint.info.authors.add("Florian Schmitt");
        RandomWaypoint.info.affiliation = "University of Bonn - Institute of Computer Science 4 (http://net.cs.uni-bonn.de/)";
    }
}

