/*
 * Decompiled with CFR 0.152.
 */
package bonnmotion;

import bonnmotion.App;
import bonnmotion.AttractorField;
import bonnmotion.Building;
import bonnmotion.Dimension;
import bonnmotion.DisasterArea;
import bonnmotion.IntegerHashSet;
import bonnmotion.MobileNode;
import bonnmotion.Model;
import bonnmotion.Position;
import bonnmotion.Printer;
import bonnmotion.ScenarioLink;
import bonnmotion.ScenarioLinkException;
import bonnmotion.ScenarioParameters;
import bonnmotion.Waypoint;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.Random;
import java.util.StringTokenizer;
import java.util.zip.GZIPInputStream;

public class Scenario
extends App
implements Model,
ScenarioLink {
    protected ScenarioParameters parameterData = new ScenarioParameters();
    protected Building[] buildings = new Building[0];
    protected Random rand;
    public long count_rands = 0L;
    private boolean isOutputDimSetExplicitly = false;
    private static boolean negativeHeightWarningShowed = false;
    protected boolean isTransition = false;
    protected int transitionMode = 0;
    protected Scenario predecessorScenario = null;
    public String movements = null;

    public Scenario() {
    }

    public Scenario(int nodes, double x, double y, double duration, double ignore, long randomSeed) {
        this(nodes, x, y, 0.0, duration, ignore, randomSeed);
    }

    public Scenario(int nodes, double x, double y, double z, double duration, double ignore, long randomSeed) {
        this.parameterData.nodes = new MobileNode[nodes];
        this.parameterData.x = x;
        this.parameterData.y = y;
        this.parameterData.z = z;
        this.parameterData.duration = duration;
        this.parameterData.ignore = ignore;
        this.parameterData.randomSeed = randomSeed;
        this.setRand(new Random(this.parameterData.randomSeed));
    }

    protected Scenario(String basename) throws FileNotFoundException, IOException {
        this.read(basename);
    }

    protected Scenario(String basename, boolean haveLD) throws FileNotFoundException, IOException {
        this.read(basename, haveLD);
    }

    protected Scenario(String[] args, Scenario _pre, Integer _transitionMode) {
        this.predecessorScenario = _pre;
        this.transitionMode = _transitionMode;
        this.isTransition = true;
    }

    public static Scenario getScenario(String basename) throws FileNotFoundException, IOException {
        return new Scenario(basename);
    }

    public double getZ() {
        return this.parameterData.z;
    }

    @Override
    protected boolean parseArg(char key, String val) {
        switch (key) {
            case 'a': {
                this.parameterData.aFieldParams = Scenario.parseDoubleArray(val);
                return true;
            }
            case 'c': {
                this.parameterData.circular = true;
                return true;
            }
            case 'd': {
                this.parameterData.duration = Double.parseDouble(val);
                return true;
            }
            case 'i': {
                this.parameterData.ignore = Double.parseDouble(val);
                if (this.isTransition && this.predecessorScenario != null && this.parameterData.ignore != 0.0) {
                    System.out.println("warning: Ingore is set to " + this.parameterData.ignore + ". Are you sure you want this in a chained Scenario?");
                }
                return true;
            }
            case 'n': {
                this.parameterData.nodes = new MobileNode[Integer.parseInt(val)];
                return true;
            }
            case 'J': {
                if (val.equals("2D") || val.equals("2d")) {
                    this.isOutputDimSetExplicitly = true;
                    this.setOutputDimension2D();
                    return true;
                }
                if (val.equals("3D") || val.equals("3d")) {
                    this.isOutputDimSetExplicitly = true;
                    this.setOutputDimension3D();
                    return true;
                }
                return false;
            }
            case 'x': {
                this.parameterData.x = Double.parseDouble(val);
                return true;
            }
            case 'y': {
                this.parameterData.y = Double.parseDouble(val);
                return true;
            }
            case 'z': {
                this.setCalculationDimension3D();
                if (!this.isOutputDimSetExplicitly) {
                    this.setOutputDimension3D();
                }
                this.parameterData.z = Double.parseDouble(val);
                if (this.parameterData.z == 0.0) {
                    System.out.println("warning: Calculations are now performed in 3D, even though z == 0.\nIf you don't want this behaviour, remove z-flag.");
                }
                return true;
            }
            case 'R': {
                this.parameterData.randomSeed = Long.parseLong(val);
                return true;
            }
        }
        return super.parseArg(key, val);
    }

    protected boolean parseArg(String key, String val) {
        if (key.equals("model")) {
            this.parameterData.modelName = val;
            return true;
        }
        if (key.equals("ignore")) {
            this.parameterData.ignore = Double.parseDouble(val);
            return true;
        }
        if (key.equals("randomSeed")) {
            System.out.println("randomSeed (String):" + val);
            this.parameterData.randomSeed = Long.parseLong(val);
            System.out.println("randomSeed (Long):" + this.parameterData.randomSeed);
            return true;
        }
        if (key.equals("x")) {
            this.parameterData.x = Double.parseDouble(val);
            return true;
        }
        if (key.equals("y")) {
            this.parameterData.y = Double.parseDouble(val);
            return true;
        }
        if (key.equals("z")) {
            this.setCalculationDimension3D();
            if (!this.isOutputDimSetExplicitly) {
                this.setOutputDimension3D();
            }
            this.parameterData.z = Double.parseDouble(val);
            return true;
        }
        if (key.equals("J")) {
            if (val.equals("2D") || val.equals("2d")) {
                this.isOutputDimSetExplicitly = true;
                this.setOutputDimension2D();
                return true;
            }
            if (val.equals("3D") || val.equals("3d")) {
                this.isOutputDimSetExplicitly = true;
                this.setOutputDimension3D();
                return true;
            }
            return false;
        }
        if (key.equals("nn")) {
            this.parameterData.nodes = new MobileNode[Integer.parseInt(val)];
            return true;
        }
        if (key.equals("duration")) {
            this.parameterData.duration = Double.parseDouble(val);
            return true;
        }
        if (key.equals("nbuildings")) {
            this.buildings = new Building[Integer.parseInt(val)];
            return true;
        }
        if (key.equals("circular")) {
            if (val.equals("true")) {
                this.parameterData.circular = true;
            }
            return true;
        }
        if (key.equals("aFieldParams")) {
            this.parameterData.aFieldParams = Scenario.parseDoubleArray(val);
            return true;
        }
        return false;
    }

    public Position randomNextPosition() {
        Position pos = this.randomNextPosition(-1.0, -1.0, -1.0);
        return pos;
    }

    public Position randomNextPosition(double fx, double fy, double fz) {
        double x2 = 0.0;
        double y2 = 0.0;
        double z2 = 0.0;
        double r = 0.0;
        double rx = 0.0;
        double ry = 0.0;
        double rz = 0.0;
        if (this.parameterData.circular) {
            x2 = this.parameterData.x / 2.0;
            y2 = this.parameterData.y / 2.0;
            if (this.parameterData.calculationDim == Dimension.THREED) {
                z2 = this.parameterData.z / 2.0;
                r = x2 < y2 ? (x2 < z2 ? x2 : z2) : (y2 < z2 ? y2 : z2);
            } else {
                z2 = 0.0;
                r = x2 < y2 ? x2 : y2;
            }
        }
        Position pos = null;
        do {
            if (this.parameterData.aField == null) {
                rx = fx < 0.0 ? this.parameterData.x * this.randomNextDouble() : fx;
                ry = fy < 0.0 ? this.parameterData.y * this.randomNextDouble() : fy;
                rz = 0.0;
                if (this.parameterData.calculationDim != Dimension.THREED) continue;
                rz = fz < 0.0 ? this.parameterData.z * this.randomNextDouble() : fz;
                continue;
            }
            if (this.parameterData.calculationDim == Dimension.THREED) {
                throw new RuntimeException("Not Implemented");
            }
            pos = this.parameterData.aField.getPos(this.randomNextDouble(), this.randomNextGaussian(), this.randomNextGaussian());
            if (pos == null) continue;
            rx = pos.x;
            ry = pos.y;
        } while (this.parameterData.aField != null && pos == null || this.parameterData.circular && Math.sqrt((rx - x2) * (rx - x2) + (ry - y2) * (ry - y2) + (rz - z2) * (rz - z2)) > r);
        if (pos == null) {
            return new Position(rx, ry, rz);
        }
        return pos;
    }

    public static void printHelp() {
        App.printHelp();
        System.out.println("Scenario:");
        System.out.println("\t-a <attractor parameters (if applicable for model)>");
        System.out.println("\t-c [use circular shape (if applicable for model)]");
        System.out.println("\t-d <scenario duration>");
        System.out.println("\t-i <number of seconds to skip>");
        System.out.println("\t-n <number of nodes>");
        System.out.println("\t-x <width of simulation area>");
        System.out.println("\t-y <height of simulation area>");
        System.out.println("\t-z <depth of simulation area>");
        System.out.println("\t-R <random seed>");
        System.out.println("\t-J <2D, 3D> Dimension of movement output");
    }

    protected String read(String basename) throws FileNotFoundException, IOException {
        String help = this.read(basename, false);
        return help;
    }

    protected String read(String basename, boolean hasPrecomputedLinkDump) throws FileNotFoundException, IOException {
        this.paramFromFile(basename + ".params");
        if (this.buildings.length > 0) {
            this.readBuildings(basename);
        }
        StringBuilder movements = new StringBuilder();
        if (!hasPrecomputedLinkDump) {
            if (this.parameterData.outputDim == Dimension.THREED) {
                this.buildScenarioFromMovementFile3D(basename, movements);
            } else {
                this.buildScenarioFromMovementFile2D(basename, movements);
            }
        }
        this.movements = movements.toString();
        return this.movements;
    }

    private void buildScenarioFromMovementFile3D(String basename, StringBuilder movements) throws IOException, FileNotFoundException {
        String line;
        double extendedtime = 0.0;
        double xpos = 0.0;
        double ypos = 0.0;
        double zpos = 0.0;
        double status = 0.0;
        boolean nodestart = false;
        boolean nodestop = false;
        BufferedReader in = new BufferedReader(new InputStreamReader(new GZIPInputStream(new FileInputStream(basename + ".movements.gz"))));
        int i = 0;
        int j = 0;
        while ((line = in.readLine()) != null) {
            if (line.startsWith("#")) continue;
            if (!this.getModelName().equals(DisasterArea.getInfo().name)) {
                this.parameterData.nodes[i] = new MobileNode();
            }
            StringTokenizer st = new StringTokenizer(line);
            block8: while (st.hasMoreTokens()) {
                if (this.getModelName().equals(DisasterArea.getInfo().name)) {
                    switch (i % 5) {
                        case 0: {
                            extendedtime = Double.parseDouble(st.nextToken());
                            nodestart = extendedtime == 0.0;
                            if (extendedtime == this.parameterData.duration) {
                                nodestop = true;
                                continue block8;
                            }
                            nodestop = false;
                            continue block8;
                        }
                        case 1: {
                            xpos = Double.parseDouble(st.nextToken());
                            continue block8;
                        }
                        case 2: {
                            ypos = Double.parseDouble(st.nextToken());
                            continue block8;
                        }
                        case 3: {
                            zpos = Double.parseDouble(st.nextToken());
                            continue block8;
                        }
                        case 4: {
                            Position extendedpos;
                            status = Double.parseDouble(st.nextToken());
                            if (nodestart) {
                                this.parameterData.nodes[j] = new MobileNode();
                            }
                            if (!this.parameterData.nodes[j].add(extendedtime, extendedpos = new Position(xpos, ypos, zpos, status))) {
                                System.out.println(extendedtime + ": " + extendedpos.x + "/" + extendedpos.y + "/" + extendedpos.z);
                                throw new RuntimeException("Error while adding waypoint.");
                            }
                            if (nodestop) {
                                ++j;
                            }
                            movements.append(" ");
                            movements.append(extendedtime);
                            movements.append(" ");
                            movements.append(xpos);
                            movements.append(" ");
                            movements.append(ypos);
                            movements.append(" ");
                            movements.append(zpos);
                            movements.append(" ");
                            movements.append(status);
                            if (this.parameterData.duration != extendedtime) continue block8;
                            movements.append("\n");
                            continue block8;
                        }
                    }
                    continue;
                }
                double time = Double.parseDouble(st.nextToken());
                Position pos = new Position(Double.parseDouble(st.nextToken()), Double.parseDouble(st.nextToken()), Double.parseDouble(st.nextToken()));
                if (!negativeHeightWarningShowed && pos.z < 0.0) {
                    System.err.printf("NOTE: your input contains a node with a negative z-value (%f;%f;%f).\nThe following behaviour is not tested enough. Especially be careful with the resulting statistics!\n", pos.x, pos.y, pos.z);
                    negativeHeightWarningShowed = true;
                }
                if (this.parameterData.nodes[i].add(time, pos)) continue;
                System.out.println(time + ": " + pos.x + "/" + pos.y + "/" + pos.z);
                in.close();
                throw new RuntimeException("Error while adding waypoint.");
            }
            ++i;
        }
        in.close();
    }

    private void buildScenarioFromMovementFile2D(String basename, StringBuilder movements) throws IOException, FileNotFoundException {
        String line;
        double extendedtime = 0.0;
        double xpos = 0.0;
        double ypos = 0.0;
        double status = 0.0;
        boolean nodestart = false;
        boolean nodestop = false;
        BufferedReader in = new BufferedReader(new InputStreamReader(new GZIPInputStream(new FileInputStream(basename + ".movements.gz"))));
        int i = 0;
        int j = 0;
        while ((line = in.readLine()) != null) {
            if (line.startsWith("#")) continue;
            if (!this.getModelName().equals(DisasterArea.getInfo().name)) {
                this.parameterData.nodes[i] = new MobileNode();
            }
            StringTokenizer st = new StringTokenizer(line);
            block7: while (st.hasMoreTokens()) {
                Position pos;
                if (this.getModelName().equals(DisasterArea.getInfo().name)) {
                    switch (i % 4) {
                        case 0: {
                            extendedtime = Double.parseDouble(st.nextToken());
                            nodestart = extendedtime == 0.0;
                            if (extendedtime == this.parameterData.duration) {
                                nodestop = true;
                                continue block7;
                            }
                            nodestop = false;
                            continue block7;
                        }
                        case 1: {
                            xpos = Double.parseDouble(st.nextToken());
                            continue block7;
                        }
                        case 2: {
                            ypos = Double.parseDouble(st.nextToken());
                            continue block7;
                        }
                        case 3: {
                            Position extendedpos;
                            status = Double.parseDouble(st.nextToken());
                            if (nodestart) {
                                this.parameterData.nodes[j] = new MobileNode();
                            }
                            if (!this.parameterData.nodes[j].add(extendedtime, extendedpos = new Position(xpos, ypos, 0.0, status))) {
                                System.out.println(extendedtime + ": " + extendedpos.x + "/" + extendedpos.y);
                                in.close();
                                throw new RuntimeException("Error while adding waypoint.");
                            }
                            if (nodestop) {
                                ++j;
                            }
                            movements.append(" ");
                            movements.append(extendedtime);
                            movements.append(" ");
                            movements.append(xpos);
                            movements.append(" ");
                            movements.append(ypos);
                            movements.append(" ");
                            movements.append(status);
                            if (this.parameterData.duration != extendedtime) continue block7;
                            movements.append("\n");
                            continue block7;
                        }
                    }
                    continue;
                }
                double time = Double.parseDouble(st.nextToken());
                if (this.parameterData.nodes[i].add(time, pos = new Position(Double.parseDouble(st.nextToken()), Double.parseDouble(st.nextToken())))) continue;
                System.out.println(time + ": " + pos.x + "/" + pos.y);
                in.close();
                throw new RuntimeException("Error while adding waypoint.");
            }
            ++i;
        }
        in.close();
    }

    private void readBuildings(String basename) throws FileNotFoundException, IOException {
        String line;
        int i = 0;
        BufferedReader buildingsReader = new BufferedReader(new InputStreamReader(new FileInputStream(basename + ".buildings")));
        while ((line = buildingsReader.readLine()) != null) {
            StringTokenizer st = new StringTokenizer(line);
            this.buildings[i] = new Building(Double.parseDouble(st.nextToken()), Double.parseDouble(st.nextToken()), Double.parseDouble(st.nextToken()), Double.parseDouble(st.nextToken()), Double.parseDouble(st.nextToken()), Double.parseDouble(st.nextToken()));
            ++i;
        }
        buildingsReader.close();
    }

    public Building[] getBuilding() {
        Building[] b = new Building[this.buildings.length];
        System.arraycopy(this.buildings, 0, b, 0, this.buildings.length);
        return b;
    }

    public MobileNode[] getNode() {
        MobileNode[] r = new MobileNode[this.parameterData.nodes.length];
        System.arraycopy(this.parameterData.nodes, 0, r, 0, this.parameterData.nodes.length);
        return r;
    }

    public MobileNode[] getNode(String Modelname, String basename) {
        if (Modelname.equals(DisasterArea.getInfo().name)) {
            IntegerHashSet VanishingNodes = this.searchVanishing(basename);
            int writtenNodes = 0;
            MobileNode[] r = new MobileNode[this.parameterData.nodes.length - VanishingNodes.size()];
            for (int i = 0; i < this.parameterData.nodes.length; ++i) {
                boolean vanish = false;
                Integer nodeaddress = i;
                if (VanishingNodes.contains(nodeaddress)) {
                    vanish = true;
                }
                if (vanish) continue;
                System.arraycopy(this.parameterData.nodes, i, r, writtenNodes, 1);
                ++writtenNodes;
            }
            return r;
        }
        return null;
    }

    public MobileNode getNode(int n) {
        try {
            if (this.parameterData.nodes[n] == null) {
                this.parameterData.nodes[n] = new MobileNode();
            }
            return this.parameterData.nodes[n];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            System.err.println("Fatal error: Requesting non-existing node" + e.getLocalizedMessage());
            System.exit(-1);
            return null;
        }
    }

    public double randomNextDouble() {
        ++this.count_rands;
        return this.getRand().nextDouble();
    }

    public double randomNextDouble(double value) {
        ++this.count_rands;
        return this.getRand().nextDouble() * value;
    }

    public double randomNextPlusOrMinusOne() {
        ++this.count_rands;
        if (this.getRand().nextBoolean()) {
            return 1.0;
        }
        return -1.0;
    }

    public int randomNextInt(int n) {
        ++this.count_rands;
        return this.getRand().nextInt(n);
    }

    public int randomNextInt() {
        ++this.count_rands;
        return this.getRand().nextInt();
    }

    public double randomNextGaussian() {
        ++this.count_rands;
        return this.getRand().nextGaussian();
    }

    public double randomNextWeibull(double shape, double scale) {
        ++this.count_rands;
        return scale * Math.pow(-Math.log(this.getRand().nextDouble()), 1.0 / shape);
    }

    protected void preGeneration() {
        if (this.parameterData.outputDim == Dimension.THREED) {
            System.out.println("note: Output is now in 3D.");
        }
        this.parameterData.duration += this.parameterData.ignore;
        this.setRand(new Random(this.parameterData.randomSeed));
        if (this.parameterData.aFieldParams != null) {
            this.parameterData.aField = new AttractorField(this.parameterData.x, this.parameterData.y);
            this.parameterData.aField.add(this.parameterData.aFieldParams);
        }
        String myClass = this.getClass().getName();
        myClass = myClass.substring(myClass.lastIndexOf(46) + 1);
        if (this.parameterData.modelName == null) {
            this.parameterData.modelName = myClass;
        } else if (!this.parameterData.modelName.equals(myClass)) {
            System.out.println("model mismatch: modelName=" + this.parameterData.modelName + " myClass=" + myClass);
            System.exit(0);
        }
    }

    protected void postGeneration() {
        if (this.parameterData.ignore < 600.0 && !this.isTransition) {
            System.out.println("warning: setting the initial phase to be cut off to be too short may result in very weird scenarios");
        }
        if (this.parameterData.ignore > 0.0) {
            this.cut(this.parameterData.ignore, this.parameterData.duration);
        }
        long next_seed = this.getRand().nextLong();
        while (Long.signum(next_seed) < 0) {
            next_seed = this.getRand().nextLong();
        }
        System.out.println("Next RNG-Seed =" + next_seed + " | #Randoms = " + this.count_rands);
    }

    public void cut(double begin, double end) {
        if (begin >= 0.0 && end <= this.parameterData.duration && begin <= end) {
            for (int i = 0; i < this.parameterData.nodes.length; ++i) {
                this.parameterData.nodes[i].cut(begin, end);
            }
            this.parameterData.duration = end - begin;
        }
    }

    @Override
    public void go(String[] _args) {
        String paramFile = _args[0];
        String[] args = new String[_args.length - 1];
        System.arraycopy(_args, 1, args, 0, args.length);
        if (paramFile != null) {
            try {
                this.paramFromFile(paramFile, true);
            }
            catch (Exception e) {
                Scenario.exceptionHandler("Could not open parameter file", e);
            }
        }
        this.parse(args);
        if (this.parameterData.nodes == null) {
            System.out.println("Please define the number of nodes.");
            System.exit(0);
        }
    }

    @Override
    public String getModelName() {
        return this.parameterData.modelName;
    }

    public void setModelName(String _modelName) {
        this.parameterData.modelName = _modelName;
    }

    public IntegerHashSet searchVanishing(String basename) {
        IntegerHashSet VanishingNodes = new IntegerHashSet();
        return VanishingNodes;
    }

    public double getX() {
        return this.parameterData.x;
    }

    public double getY() {
        return this.parameterData.y;
    }

    public double getIgnore() {
        return this.parameterData.ignore;
    }

    public long getRandomSeed() {
        return this.parameterData.randomSeed;
    }

    public void setNode(MobileNode[] _node) {
        this.parameterData.nodes = _node;
    }

    public int nodeCount() {
        return this.parameterData.nodes.length;
    }

    public int nodeCount(String Modelname, String basename) {
        if (Modelname.equals(DisasterArea.getInfo().name)) {
            return this.parameterData.nodes.length - this.searchVanishing(basename).size();
        }
        return this.parameterData.nodes.length;
    }

    public void paramFromFile(String _fn) throws FileNotFoundException, IOException {
        this.paramFromFile(_fn, false);
    }

    public void paramFromFile(String _fn, boolean _warn) throws FileNotFoundException, IOException {
        String line;
        BufferedReader in = new BufferedReader(new InputStreamReader(new FileInputStream(_fn)));
        while ((line = in.readLine()) != null) {
            String value;
            StringTokenizer st = new StringTokenizer(line, "=");
            String key = st.nextToken();
            if (this.parseArg(key, value = st.nextToken()) || !_warn) continue;
            System.out.println("warning: unknown key \"" + key + "\" while parsing arguments from \"" + _fn + "\"");
        }
        in.close();
    }

    public void setDuration(double _duration) {
        this.parameterData.duration = _duration;
    }

    @Override
    public void write(String _name) throws FileNotFoundException, IOException {
        this.writeParametersAndMovement(_name, null);
    }

    public void writeParametersAndMovement(String basename, String[] params) throws FileNotFoundException, IOException {
        Printer printer = new Printer(this.parameterData.outputDim);
        printer.writeOutsourced(basename, this.parameterData, params);
    }

    @Override
    public Waypoint transition(Scenario _pre, int _mode, int _nn) throws ScenarioLinkException {
        if (_pre == null) {
            return new Waypoint(0.0, this.randomNextPosition());
        }
        if (_pre.parameterData.nodes.length != this.parameterData.nodes.length) {
            throw new ScenarioLinkException("#Node does not match");
        }
        MobileNode[] preNodes = null;
        Waypoint w = null;
        Waypoint nw = null;
        preNodes = _pre.getNode();
        w = preNodes[_nn].getLastWaypoint();
        switch (_mode) {
            case 0: {
                nw = this.transitionWaypointFast(w);
                break;
            }
            case 1: {
                nw = this.transitionWaypointMove(w, _nn);
                break;
            }
            default: {
                throw new ScenarioLinkException("Unknown Mode");
            }
        }
        this.parameterData.nodes[_nn].add(nw.time, nw.pos);
        return nw;
    }

    @Override
    public Waypoint transitionWaypointFast(Waypoint _w) {
        Waypoint w = null;
        if (_w.pos.x > this.parameterData.x || _w.pos.y > this.parameterData.y) {
            System.out.println("\t\tOut!!!!  X: " + _w.pos.x + " / Y: " + _w.pos.y);
            double xRe = _w.pos.x - (double)((int)(_w.pos.x / this.parameterData.x)) * (_w.pos.x % this.parameterData.x);
            double yRe = _w.pos.y - (double)((int)(_w.pos.y / this.parameterData.y)) * (_w.pos.y % this.parameterData.y);
            System.out.println("\t\tNew Pos: X: " + xRe + " / Y: " + yRe);
            w = new Waypoint(0.0, new Position(xRe, yRe));
        } else {
            w = new Waypoint(0.0, _w.pos);
        }
        return w;
    }

    @Override
    public Waypoint transitionWaypointMove(Waypoint _w, int _nn) {
        Waypoint w = this.transitionWaypointFast(_w);
        if (w.pos.x != _w.pos.x || w.pos.y != _w.pos.y) {
            this.parameterData.nodes[_nn].add(0.0, _w.pos);
            return new Waypoint(2.0, w.pos);
        }
        return new Waypoint(0.0, _w.pos);
    }

    public Random getRand() {
        return this.rand;
    }

    public void setRand(Random rand) {
        this.rand = rand;
    }

    public void setOutputDimension3D() {
        this.parameterData.outputDim = Dimension.THREED;
    }

    public void setOutputDimension2D() {
        this.parameterData.outputDim = Dimension.TWOD;
    }

    public void setCalculationDimension3D() {
        System.out.println("note: Calculations are now performed in 3D, since depth value z is provided.");
        this.parameterData.calculationDim = Dimension.THREED;
    }

    public void setCalculationDimension2D() {
        this.parameterData.calculationDim = Dimension.TWOD;
    }

    public ScenarioParameters getScenarioParameters() {
        return this.parameterData;
    }

    public double getDuration() {
        return this.parameterData.duration;
    }

    public void writeCoordinates(PrintWriter info) {
        info.println("x=" + this.parameterData.x);
        info.println("y=" + this.parameterData.y);
        info.println("z=" + this.parameterData.z);
    }
}

