/*
 * Decompiled with CFR 0.152.
 */
package bonnmotion;

import bonnmotion.Dimension;
import bonnmotion.PositionInterface;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;

public class Position
implements PositionInterface {
    public double x;
    public double y;
    public double z;
    public final double status;

    public Position() {
        this(0.0, 0.0, 0.0, 0.0);
    }

    public Position(Position p) {
        this(p.x, p.y, p.z);
    }

    public Position(double x, double y) {
        this(x, y, 0.0, 0.0);
    }

    public Position(double x, double y, double z) {
        this(x, y, z, 0.0);
    }

    public Position(double x, double y, double z, double status) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.status = status;
    }

    public double distance(Position _p) {
        Position p = _p;
        double deltaX = p.x - this.x;
        double deltaY = p.y - this.y;
        double deltaZ = p.z - this.z;
        return Math.sqrt(deltaX * deltaX + deltaY * deltaY + deltaZ * deltaZ);
    }

    @Override
    public double distance(PositionInterface p) {
        assert (p instanceof Position);
        return this.distance((Position)p);
    }

    public Position rndprox(double maxdist, double _dist, double _dir, Dimension dim) {
        double dist = _dist * maxdist;
        double dir = _dir * 2.0 * Math.PI;
        double newZ = dim == Dimension.THREED ? this.z + (Math.cos(dir) + Math.sin(dir) - 1.0) * dist : 0.0;
        return new Position(this.x + Math.cos(dir) * dist, this.y + Math.sin(dir) * dist, newZ, this.status);
    }

    public double norm() {
        return Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
    }

    public String toString() {
        return "(" + this.x + ", " + this.y + ", " + this.z + ")";
    }

    public String toString(int precision) {
        int mult = 1;
        for (int i = 0; i < precision; ++i) {
            mult *= 10;
        }
        return "(" + (double)((int)(this.x * (double)mult + 0.5)) / (double)mult + ", " + (double)((int)(this.y * (double)mult + 0.5)) / (double)mult + ", " + (double)((int)(this.z * (double)mult + 0.5)) / (double)mult + ")";
    }

    public boolean equals(Position _p) {
        Position p = _p;
        return p.x == this.x && p.y == this.y && p.z == this.z;
    }

    public static Position diff(Position p, Position q) {
        return new Position(q.x - p.x, q.y - p.y, q.z - p.z);
    }

    public static double scalarProduct(Position p, Position q) {
        return p.x * q.x + p.y * q.y + p.z * q.z;
    }

    public static double slope(Line2D.Double line) {
        if (line.x2 - line.x1 == 0.0) {
            return Double.MAX_VALUE;
        }
        double slope = (line.y2 - line.y1) / (line.x2 - line.x1);
        return slope;
    }

    public Position getWeightenedPosition(Position _w, double weight) {
        Position w = _w;
        return new Position(this.x * (1.0 - weight) + w.x * weight, this.y * (1.0 - weight) + w.y * weight, this.z * (1.0 - weight) + w.z * weight, this.status);
    }

    public Position newShiftedPosition(double _x, double _y, double _z) {
        return new Position(this.x + _x, this.y + _y, this.z + _z);
    }

    public Position newShiftedPosition(double _x, double _y) {
        return new Position(this.x + _x, this.y + _y);
    }

    public Position clone(double status) {
        return new Position(this.x, this.y, this.z, status);
    }

    public double angle(Position p) {
        return Position.angle(p, this);
    }

    public static double angle(Position p, Position q) {
        return Math.acos(Position.scalarProduct(p, q) / (p.norm() * q.norm()));
    }

    public static double angle2(Position _p, Position _q) {
        Position p = _p;
        Position q = _q;
        double a = Position.angle(p, q);
        double o = Position.angle(new Position(-p.y, p.x, p.z), q);
        if (o > 1.5707963267948966) {
            a = Math.PI * 2 - a;
        }
        return a;
    }

    public Position add(Position p) {
        this.x += p.x;
        this.y += p.y;
        this.z += p.z;
        return this;
    }

    public static Position add(Position p, Position q) {
        return new Position(p).add(q);
    }

    public Position subtract(Position p) {
        this.x -= p.x;
        this.y -= p.y;
        this.z -= p.z;
        return this;
    }

    public static Position subtract(Position p, Position q) {
        return new Position(p).subtract(q);
    }

    public Position multiply(double m) {
        this.x *= m;
        this.y *= m;
        this.z *= m;
        return this;
    }

    public static Position multiply(Position p, double m) {
        return new Position(p).multiply(m);
    }

    public Point2D.Double getPoint2D() {
        return new Point2D.Double(this.x, this.y);
    }
}

