/*
 * Decompiled with CFR 0.152.
 */
package bonnmotion;

import bonnmotion.Position;
import java.awt.Polygon;
import java.awt.geom.Line2D;
import java.util.LinkedList;

public class Obstacle
extends Polygon {
    private static final long serialVersionUID = -259947914997848502L;
    double[] Vertices = null;
    Position[] PosVert = null;
    LinkedList<Line2D.Double> Edges = new LinkedList();

    public Obstacle(double[] Vertices) {
        int i;
        Position[] temp = new Position[Vertices.length / 2];
        for (i = 0; i < Vertices.length; i += 2) {
            Position entry;
            this.addPoint((int)Vertices[i], (int)Vertices[i + 1]);
            temp[i / 2] = entry = new Position(Vertices[i], Vertices[i + 1]);
        }
        this.PosVert = temp;
        this.Vertices = Vertices;
        for (i = 0; i < Vertices.length - 2; i += 2) {
            Line2D.Double Edge = new Line2D.Double(Vertices[i], Vertices[i + 1], Vertices[i + 2], Vertices[i + 3]);
            this.Edges.add(Edge);
        }
        Line2D.Double closingEdge = new Line2D.Double(Vertices[Vertices.length - 2], Vertices[Vertices.length - 1], Vertices[0], Vertices[1]);
        this.Edges.add(closingEdge);
    }

    public void print() {
        System.out.println("Vertices of Obstacle ");
        for (int i = 0; i < this.Vertices.length; ++i) {
            System.out.print(this.Vertices[i] + ",");
            if (i != this.Vertices.length - 1) continue;
            System.out.println("");
        }
    }

    public boolean intersectsLine(double xstart, double ystart, double xstop, double ystop) {
        Line2D.Double WayOfNode = new Line2D.Double(xstart, ystart, xstop, ystop);
        boolean intersection = false;
        for (int i = 0; i < this.Edges.size(); ++i) {
            intersection = WayOfNode.intersectsLine(this.Edges.get(i));
            if (!intersection) continue;
            return true;
        }
        return false;
    }

    public int intersectsObstacle(double xstart, double ystart, double xstop, double ystop) {
        Line2D.Double WayOfNode = new Line2D.Double(xstart, ystart, xstop, ystop);
        boolean intersection = false;
        int numintersections = 0;
        for (int i = 0; i < this.Edges.size(); ++i) {
            intersection = WayOfNode.intersectsLine(this.Edges.get(i));
            if (!intersection) continue;
            ++numintersections;
        }
        return numintersections;
    }

    public boolean throughObstacle(double xstart, double ystart, double xstop, double ystop) {
        Line2D.Double WayOfNode = new Line2D.Double(xstart, ystart, xstop, ystop);
        boolean valid = false;
        double xonline = WayOfNode.x1 + (WayOfNode.x2 - WayOfNode.x1) / 2.0;
        double yonline = WayOfNode.y1 + (WayOfNode.y2 - WayOfNode.y1) / 2.0;
        valid = this.contains(xonline, yonline);
        return valid;
    }

    public boolean sameObstacle(Position vertice1, Position vertice2) {
        boolean isvertice1 = false;
        boolean isvertice2 = false;
        for (int i = 0; i < this.PosVert.length; ++i) {
            if (vertice1.equals(this.PosVert[i])) {
                isvertice1 = true;
            }
            if (!vertice2.equals(this.PosVert[i])) continue;
            isvertice2 = true;
        }
        return isvertice1 && isvertice2;
    }

    public double minDistance(Position pos) {
        double distance = 0.0;
        double mindist = Double.MAX_VALUE;
        for (int i = 0; i < this.Edges.size(); ++i) {
            distance = this.Edges.get(i).ptSegDist(pos.x, pos.y);
            if (!(distance < mindist)) continue;
            mindist = distance;
        }
        return mindist;
    }

    public double[] getVertices() {
        return this.Vertices;
    }

    public Position[] getPosVertices() {
        return this.PosVert;
    }

    public LinkedList<Line2D.Double> getEdges() {
        return this.Edges;
    }

    public String VerticesToString() {
        Object represent = new String();
        for (int i = 0; i < this.Vertices.length; ++i) {
            Double help = new Double(this.Vertices[i]);
            represent = (String)represent + " " + help.toString();
        }
        return represent;
    }

    public boolean isVertice(Position totest) {
        for (int i = 0; i < this.PosVert.length; ++i) {
            if (!this.PosVert[i].equals(totest)) continue;
            return true;
        }
        return false;
    }

    public Obstacle computeCObstacle(double dist, int circlevertices) {
        Polygon robotpos = new Polygon();
        double angle = Math.toRadians(360 / circlevertices);
        Polygon tempobstacle = new Polygon();
        Position[] circlepos = new Position[circlevertices];
        for (int i = 0; i < circlevertices; ++i) {
            circlepos[i] = new Position(dist * Math.cos((double)i * angle), dist * Math.sin((double)i * angle));
            robotpos.addPoint((int)Math.rint(circlepos[i].x), (int)Math.rint(circlepos[i].y));
        }
        tempobstacle = this.MinkowskiSum(robotpos);
        double[] temp = new double[2 * tempobstacle.npoints];
        for (int i = 0; i < tempobstacle.npoints; ++i) {
            temp[2 * i] = tempobstacle.xpoints[i];
            temp[2 * i + 1] = tempobstacle.ypoints[i];
        }
        Obstacle obs = new Obstacle(temp);
        return obs;
    }

    public Polygon MinkowskiSum(Polygon robotpos) {
        int i;
        Polygon newobs = new Polygon();
        LinkedList<Position> positions = new LinkedList<Position>();
        boolean alreadyInserted = false;
        for (i = 0; i < this.PosVert.length; ++i) {
            for (int j = 0; j < robotpos.npoints; ++j) {
                Position pos = new Position(this.PosVert[i].x - (double)robotpos.xpoints[j], this.PosVert[i].y - (double)robotpos.ypoints[j]);
                alreadyInserted = false;
                for (int p = 0; p < positions.size(); ++p) {
                    if (!((Position)positions.get(p)).equals(pos)) continue;
                    alreadyInserted = true;
                }
                if (alreadyInserted) continue;
                positions.add(pos);
            }
        }
        for (i = 0; i < 3; ++i) {
            newobs.addPoint((int)((Position)positions.get((int)i)).x, (int)((Position)positions.get((int)i)).y);
        }
        for (i = 3; i < positions.size(); ++i) {
            Integer help2;
            Integer help;
            Integer intobj2;
            Integer help3;
            int j;
            LinkedList<Object> temp = new LinkedList();
            boolean startset = false;
            int start = 0;
            int stop = 0;
            double startposx = 0.0;
            double startposy = 0.0;
            double stopposx = 0.0;
            double stopposy = 0.0;
            LinkedList<Integer> xcoordinates = new LinkedList<Integer>();
            LinkedList<Integer> ycoordinates = new LinkedList<Integer>();
            if (newobs.contains(((Position)positions.get((int)i)).x, ((Position)positions.get((int)i)).y)) continue;
            temp = this.computeTangents((Position)positions.get(i), newobs);
            if (temp.size() != 2) {
                System.out.println("Error");
                System.exit(0);
            }
            for (int j2 = 0; j2 < newobs.npoints; ++j2) {
                for (int p = 0; p < temp.size(); ++p) {
                    if (!startset) {
                        if (((Line2D.Double)temp.get((int)p)).x1 == (double)newobs.xpoints[j2] && ((Line2D.Double)temp.get((int)p)).y1 == (double)newobs.ypoints[j2]) {
                            start = j2;
                            startset = true;
                            startposx = newobs.xpoints[j2];
                            startposy = newobs.ypoints[j2];
                        }
                        if (((Line2D.Double)temp.get((int)p)).x2 != (double)newobs.xpoints[j2] || ((Line2D.Double)temp.get((int)p)).y2 != (double)newobs.ypoints[j2]) continue;
                        start = j2;
                        startset = true;
                        startposx = newobs.xpoints[j2];
                        startposy = newobs.ypoints[j2];
                        continue;
                    }
                    if (((Line2D.Double)temp.get((int)p)).x1 == (double)newobs.xpoints[j2] && ((Line2D.Double)temp.get((int)p)).y1 == (double)newobs.ypoints[j2]) {
                        stop = j2;
                        stopposx = newobs.xpoints[j2];
                        stopposy = newobs.ypoints[j2];
                    }
                    if (((Line2D.Double)temp.get((int)p)).x2 != (double)newobs.xpoints[j2] || ((Line2D.Double)temp.get((int)p)).y2 != (double)newobs.ypoints[j2]) continue;
                    stop = j2;
                    stopposx = newobs.xpoints[j2];
                    stopposy = newobs.ypoints[j2];
                }
            }
            Line2D.Double line = new Line2D.Double(startposx, startposy, stopposx, stopposy);
            int location = line.relativeCCW(((Position)positions.get((int)i)).x, ((Position)positions.get((int)i)).y);
            if (location == 1) {
                for (j = 0; j <= start; ++j) {
                    help3 = new Integer(newobs.xpoints[j]);
                    Integer help22 = new Integer(newobs.ypoints[j]);
                    xcoordinates.add(help3);
                    ycoordinates.add(help22);
                }
                Integer intobj = new Integer((int)((Position)positions.get((int)i)).x);
                intobj2 = new Integer((int)((Position)positions.get((int)i)).y);
                xcoordinates.add(intobj);
                ycoordinates.add(intobj2);
                for (int j3 = stop; j3 < newobs.npoints; ++j3) {
                    help = new Integer(newobs.xpoints[j3]);
                    help2 = new Integer(newobs.ypoints[j3]);
                    xcoordinates.add(help);
                    ycoordinates.add(help2);
                }
            } else if (location == -1) {
                for (j = 0; j <= stop; ++j) {
                    help3 = new Integer(newobs.xpoints[j]);
                    Integer help23 = new Integer(newobs.ypoints[j]);
                    xcoordinates.add(help3);
                    ycoordinates.add(help23);
                }
                Integer intobj = new Integer((int)((Position)positions.get((int)i)).x);
                intobj2 = new Integer((int)((Position)positions.get((int)i)).y);
                xcoordinates.add(intobj);
                ycoordinates.add(intobj2);
            } else if (location == 0) {
                for (j = 0; j <= start; ++j) {
                    help3 = new Integer(newobs.xpoints[j]);
                    Integer help24 = new Integer(newobs.ypoints[j]);
                    xcoordinates.add(help3);
                    ycoordinates.add(help24);
                }
                Integer intobj = new Integer((int)((Position)positions.get((int)i)).x);
                intobj2 = new Integer((int)((Position)positions.get((int)i)).y);
                xcoordinates.add(intobj);
                ycoordinates.add(intobj2);
                for (int j4 = stop; j4 < newobs.npoints; ++j4) {
                    help = new Integer(newobs.xpoints[j4]);
                    help2 = new Integer(newobs.ypoints[j4]);
                    xcoordinates.add(help);
                    ycoordinates.add(help2);
                }
            }
            newobs.reset();
            for (j = 0; j < xcoordinates.size(); ++j) {
                newobs.addPoint((Integer)xcoordinates.get(j), (Integer)ycoordinates.get(j));
            }
        }
        return newobs;
    }

    public LinkedList<Line2D.Double> computeTangents(Position p, Polygon newobs) {
        int i;
        LinkedList<Line2D.Double> newobsedges = new LinkedList<Line2D.Double>();
        LinkedList<Line2D.Double> tangents = new LinkedList<Line2D.Double>();
        LinkedList<Line2D.Double> collinearpoints = new LinkedList<Line2D.Double>();
        LinkedList<Line2D.Double> toremove = new LinkedList<Line2D.Double>();
        int factor = this.getBounds().width + this.getBounds().height;
        double minimum = Double.MAX_VALUE;
        double tmp = 0.0;
        int index = 0;
        factor = 1000;
        for (i = 0; i < newobs.npoints; ++i) {
            Line2D.Double temp = new Line2D.Double(newobs.xpoints[i], newobs.ypoints[i], newobs.xpoints[(i + 1) % newobs.npoints], newobs.ypoints[(i + 1) % newobs.npoints]);
            newobsedges.add(temp);
        }
        for (i = 0; i < newobsedges.size(); ++i) {
            if (((Line2D.Double)newobsedges.get(i)).ptSegDist(p.x, p.y) != 0.0) continue;
            Line2D.Double tangent1 = new Line2D.Double(((Line2D.Double)newobsedges.get((int)i)).x1, ((Line2D.Double)newobsedges.get((int)i)).y1, p.x, p.y);
            Line2D.Double tangent2 = new Line2D.Double(p.x, p.y, ((Line2D.Double)newobsedges.get((int)i)).x2, ((Line2D.Double)newobsedges.get((int)i)).y2);
            tangents.add(tangent1);
            tangents.add(tangent2);
            return tangents;
        }
        for (i = 0; i < newobs.npoints; ++i) {
            Line2D.Double line = new Line2D.Double(p.x, p.y, newobs.xpoints[i], newobs.ypoints[i]);
            Line2D.Double ray = new Line2D.Double(p.x, p.y, p.x + (double)factor * ((double)newobs.xpoints[i] - p.x), p.y + (double)factor * ((double)newobs.ypoints[i] - p.y));
            int numintersections = 0;
            for (int j = 0; j < newobsedges.size(); ++j) {
                boolean intersection = false;
                intersection = ray.intersectsLine((Line2D)newobsedges.get(j));
                if (intersection) {
                    ++numintersections;
                }
                if (ray.ptSegDist(((Line2D.Double)newobsedges.get((int)j)).x1, ((Line2D.Double)newobsedges.get((int)j)).y1) != 0.0 || ray.ptSegDist(((Line2D.Double)newobsedges.get((int)j)).x2, ((Line2D.Double)newobsedges.get((int)j)).y2) != 0.0) continue;
                collinearpoints.add(line);
            }
            if (numintersections != 2) continue;
            tangents.add(line);
        }
        for (i = 0; i < collinearpoints.size(); ++i) {
            Position pos1 = new Position(((Line2D.Double)collinearpoints.get((int)i)).x1, ((Line2D.Double)collinearpoints.get((int)i)).y1);
            Position pos2 = new Position(((Line2D.Double)collinearpoints.get((int)i)).x2, ((Line2D.Double)collinearpoints.get((int)i)).y2);
            tmp = pos1.distance(pos2);
            if (!(tmp < minimum)) continue;
            index = i;
            minimum = tmp;
        }
        if (collinearpoints.size() != 0) {
            int i2;
            for (i = 0; i < tangents.size(); ++i) {
                if (tangents.get(i).ptSegDist(((Line2D.Double)collinearpoints.get((int)index)).x1, ((Line2D.Double)collinearpoints.get((int)index)).y1) == 0.0 && tangents.get(i).ptSegDist(((Line2D.Double)collinearpoints.get((int)index)).x2, ((Line2D.Double)collinearpoints.get((int)index)).y2) != 0.0) continue;
            }
            tangents.add((Line2D.Double)collinearpoints.get(index));
            Line2D.Double ray = new Line2D.Double(((Line2D.Double)collinearpoints.get((int)index)).x2 + (double)factor * (((Line2D.Double)collinearpoints.get((int)index)).x1 - ((Line2D.Double)collinearpoints.get((int)index)).x2), ((Line2D.Double)collinearpoints.get((int)index)).y2 + (double)factor * (((Line2D.Double)collinearpoints.get((int)index)).y1 - ((Line2D.Double)collinearpoints.get((int)index)).y2), ((Line2D.Double)collinearpoints.get((int)index)).x1 + (double)factor * (((Line2D.Double)collinearpoints.get((int)index)).x2 - ((Line2D.Double)collinearpoints.get((int)index)).x1), ((Line2D.Double)collinearpoints.get((int)index)).y1 + (double)factor * (((Line2D.Double)collinearpoints.get((int)index)).y2 - ((Line2D.Double)collinearpoints.get((int)index)).y1));
            for (i2 = 0; i2 < collinearpoints.size(); ++i2) {
                if (ray.ptSegDist(((Line2D.Double)collinearpoints.get((int)i2)).x1, ((Line2D.Double)collinearpoints.get((int)i2)).y1) != 0.0 || ray.ptSegDist(((Line2D.Double)collinearpoints.get((int)i2)).x2, ((Line2D.Double)collinearpoints.get((int)i2)).y2) != 0.0) continue;
                toremove.add((Line2D.Double)collinearpoints.get(i2));
            }
            for (i2 = 0; i2 < toremove.size(); ++i2) {
                collinearpoints.remove(toremove.get(i2));
            }
            if (collinearpoints.size() != 0 && tangents.size() != 2) {
                minimum = Double.MAX_VALUE;
                index = 0;
                for (i2 = 0; i2 < collinearpoints.size(); ++i2) {
                    Position pos1 = new Position(((Line2D.Double)collinearpoints.get((int)i2)).x1, ((Line2D.Double)collinearpoints.get((int)i2)).y1);
                    Position pos2 = new Position(((Line2D.Double)collinearpoints.get((int)i2)).x2, ((Line2D.Double)collinearpoints.get((int)i2)).y2);
                    tmp = pos1.distance(pos2);
                    if (!(tmp < minimum)) continue;
                    index = i2;
                    minimum = tmp;
                }
                tangents.add((Line2D.Double)collinearpoints.get(index));
            }
        }
        return tangents;
    }
}

