/*
 * Decompiled with CFR 0.152.
 */
package bonnmotion;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ModuleInfo {
    public static final String BM_MAILINGLIST = "bonnmotion@lists.iai.uni-bonn.de";
    public static final String TOILERS = "Toilers - Colorado School of Mines (http://toilers.mines.edu/)";
    public static final String UNIVERSITY_OF_BONN = "University of Bonn - Institute of Computer Science 4 (http://net.cs.uni-bonn.de/)";
    public static final String UOS_SYS = "University of Osnabrueck - Institute of Computer Science (http://cs.uos.de/sys/)";
    public final String name;
    public String description = "";
    public String affiliation = "";
    public List<String> authors;
    public List<String> contacts;
    public List<String> references;
    public int major;
    public int minor;
    public int revision;

    public ModuleInfo(String _name) {
        this.name = _name;
        this.authors = new ArrayList<String>();
        this.contacts = new ArrayList<String>();
        this.references = new ArrayList<String>();
    }

    public String getFormattedVersion() {
        return String.format("v%d.%d", this.major, this.minor);
    }

    private String getFormattedList(String header, List<String> list) {
        StringBuilder sb = new StringBuilder();
        if (!list.isEmpty()) {
            sb.append(header);
            for (String x : list) {
                sb.append(x + ", ");
            }
            sb.setLength(sb.length() - 2);
            sb.append("\n");
        }
        return sb.toString();
    }

    public String toDetailString() {
        StringBuilder sb = new StringBuilder();
        String header = String.format("== %s ====================================================================", this.name);
        sb.append(String.format("%.70s\nVersion:      %s\nDescription:  %s\n", header, this.getFormattedVersion(), this.description));
        if (!this.affiliation.isEmpty()) {
            sb.append(String.format("Affiliation:  %s\n", this.affiliation));
        }
        sb.append(this.getFormattedList("Authors:      ", this.authors));
        sb.append(this.getFormattedList("Contacts:     ", this.contacts));
        sb.append(this.getFormattedList("References:   ", this.references));
        return sb.toString();
    }

    public String toShortString() {
        String firstpart = String.format("+ %-26s %s", this.name, this.getFormattedVersion());
        return String.format("%-40s %s", firstpart, this.description);
    }

    public static int getSVNRevisionStringValue(String str) {
        Pattern p = Pattern.compile("\\$LastChangedRevision:\\s(\\d+)\\s\\$");
        Matcher m = p.matcher(str);
        if (m.find()) {
            return Integer.parseInt(m.group(1));
        }
        return 0;
    }

    public static int maxRevision(int ... numbers) {
        int max = 0;
        for (int i : numbers) {
            max = Math.max(max, i);
        }
        return max;
    }
}

