/*
 * Decompiled with CFR 0.152.
 */
package bonnmotion;

import bonnmotion.Building;
import bonnmotion.Dimension;
import bonnmotion.Position;
import bonnmotion.Waypoint;
import java.util.Vector;

public class MobileNode {
    protected static final boolean printAngleStuff = false;
    protected double[] changeSpeedOrDirectionTimes = null;
    protected Vector<Waypoint> waypoints = new Vector();

    public void shiftPos(double _x, double _y) {
        for (int i = 0; i < this.waypoints.size(); ++i) {
            Waypoint oldWP = this.waypoints.get(i);
            Waypoint newWP = new Waypoint(oldWP.time, oldWP.pos.newShiftedPosition(_x, _y));
            this.waypoints.setElementAt(newWP, i);
        }
    }

    public void shiftPos(double _x, double _y, double _z) {
        for (int i = 0; i < this.waypoints.size(); ++i) {
            Waypoint oldWP = this.waypoints.get(i);
            Waypoint newWP = new Waypoint(oldWP.time, oldWP.pos.newShiftedPosition(_x, _y, _z));
            this.waypoints.setElementAt(newWP, i);
        }
    }

    public void cut(double begin, double end) {
        Position epos;
        if (this.waypoints.size() == 0) {
            return;
        }
        this.changeSpeedOrDirectionTimes = null;
        Vector<Waypoint> nwp = new Vector<Waypoint>();
        Waypoint w = null;
        double oldstatus = 0.0;
        for (int i = 0; i < this.waypoints.size(); ++i) {
            Waypoint w2 = this.waypoints.elementAt(i);
            if (w2.time >= begin && w2.time <= end) {
                w = w2;
                if (nwp.size() == 0) {
                    Position hpos = this.positionAt(begin);
                    Position bpos = hpos.clone(oldstatus);
                    nwp.addElement(new Waypoint(0.0, bpos));
                    if (w.time > begin) {
                        nwp.addElement(new Waypoint(w.time - begin, w.pos));
                    }
                } else {
                    nwp.addElement(new Waypoint(w.time - begin, w.pos));
                }
            }
            if (w2.pos.status == 2.0) {
                oldstatus = 2.0;
                continue;
            }
            if (w2.pos.status != 1.0) continue;
            oldstatus = 0.0;
        }
        if (w == null) {
            Waypoint start = new Waypoint(0.0, this.positionAt(begin));
            Waypoint stop = new Waypoint(end - begin, this.positionAt(end));
            nwp.addElement(start);
            if (!start.pos.equals(stop.pos)) {
                nwp.addElement(stop);
            }
        } else if (w.time < end && !(epos = this.positionAt(end)).equals(w.pos)) {
            nwp.addElement(new Waypoint(end - begin, epos));
        }
        this.waypoints = nwp;
    }

    public boolean add(double _time, Position _newPosition) {
        this.changeSpeedOrDirectionTimes = null;
        Waypoint newWaypoint = new Waypoint(_time, _newPosition);
        for (int waypointCount = this.waypoints.size() - 1; waypointCount >= 0; --waypointCount) {
            Waypoint previousWaypoint = this.waypoints.elementAt(waypointCount);
            if (_time > previousWaypoint.time) {
                this.waypoints.insertElementAt(newWaypoint, waypointCount + 1);
                return true;
            }
            if (_time == previousWaypoint.time) {
                return this.sameWaypointAndTime(previousWaypoint, newWaypoint);
            }
            System.err.println("warning: MobileNode: trying to insert waypoint in the past <1>.");
            System.err.println("w.time: " + previousWaypoint.time + " time: " + _time);
        }
        this.waypoints.insertElementAt(newWaypoint, 0);
        return true;
    }

    protected boolean sameWaypointAndTime(Waypoint _A, Waypoint _B) {
        if (_A.time != _B.time) {
            return false;
        }
        return _A.pos.equals(_B.pos);
    }

    public void addWaypointsOfOtherNode(MobileNode _node) {
        double timeOffset = 0.0;
        if (this.waypoints.size() > 0) {
            timeOffset = this.waypoints.lastElement().time + 1.0E-4;
        }
        for (int i = 0; i < _node.waypoints.size(); ++i) {
            Waypoint next = _node.waypoints.get(i);
            this.waypoints.add(new Waypoint(next.time + timeOffset, next.pos));
        }
    }

    public void removeLastElement() {
        this.waypoints.remove(this.waypoints.lastElement());
    }

    public Waypoint getLastWaypoint() {
        return this.waypoints.lastElement();
    }

    public int getNumWaypoints() {
        return this.waypoints.size();
    }

    public Vector<Waypoint> getWaypoints() {
        return this.waypoints;
    }

    public Waypoint getWaypoint(int idx) {
        try {
            return this.waypoints.elementAt(idx);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            System.err.println("Fatal error: Requested not existing waypoint: " + e.getLocalizedMessage());
            System.exit(-1);
            return null;
        }
    }

    public double[] changeTimes() {
        if (this.changeSpeedOrDirectionTimes == null) {
            this.changeSpeedOrDirectionTimes = new double[this.waypoints.size()];
            for (int i = 0; i < this.changeSpeedOrDirectionTimes.length; ++i) {
                this.changeSpeedOrDirectionTimes[i] = this.waypoints.elementAt((int)i).time;
            }
        }
        return this.changeSpeedOrDirectionTimes;
    }

    public String movementString(Dimension dim) {
        StringBuffer sb = new StringBuffer(100 * this.waypoints.size());
        for (int i = 0; i < this.waypoints.size(); ++i) {
            Waypoint w = this.waypoints.elementAt(i);
            sb.append(" ");
            sb.append(w.getMovementStringPart(dim));
        }
        sb.deleteCharAt(0);
        return sb.toString();
    }

    public String placementStringGlomo(String id) {
        Waypoint w = this.waypoints.elementAt(0);
        Position p = w.pos;
        return id + " 0S (" + p.x + ", " + p.y + ", " + p.z + ")";
    }

    public String[] movementStringGlomo(String id) {
        String[] r = new String[this.waypoints.size() - 1];
        for (int i = 1; i < this.waypoints.size(); ++i) {
            Waypoint w = this.waypoints.elementAt(i);
            Position p = w.pos;
            r[i - 1] = id + " " + w.time + "S (" + p.x + ", " + p.y + ", " + p.z + ")";
        }
        return r;
    }

    protected Position positionAt_old(double time) {
        Position p1 = null;
        double t1 = 0.0;
        for (int i = 0; i < this.waypoints.size(); ++i) {
            Waypoint w = this.waypoints.elementAt(i);
            if (w.time == time) {
                return w.pos;
            }
            if (w.time > time) {
                if (p1 == null || p1.equals(w.pos)) {
                    return w.pos;
                }
                double weight = (time - t1) / (w.time - t1);
                return p1.getWeightenedPosition(w.pos, weight);
            }
            p1 = w.pos;
            t1 = w.time;
        }
        return p1;
    }

    public Position positionAt(double time) {
        int begin = 0;
        int end = this.waypoints.size() - 1;
        if (end < 2) {
            return this.positionAt_old(time);
        }
        Waypoint firstWaypoint = this.waypoints.firstElement();
        Waypoint lastWaypoint = this.waypoints.lastElement();
        if (time < firstWaypoint.time) {
            return firstWaypoint.pos;
        }
        if (time > lastWaypoint.time) {
            return lastWaypoint.pos;
        }
        return this.binarySearch(begin, end, time);
    }

    protected Position binarySearch(int i, int j, double time) {
        int median = (i + j) / 2;
        Waypoint w = this.waypoints.elementAt(median);
        if (i + 1 == j) {
            Waypoint w_i = this.waypoints.elementAt(i);
            Waypoint w_j = this.waypoints.elementAt(j);
            double weight = (time - w_i.time) / (w_j.time - w_i.time);
            if (w_i.pos.equals(w_j.pos)) {
                return new Position(w_i.pos.x, w_i.pos.y, w_i.pos.z, w_i.pos.status);
            }
            return w_i.pos.getWeightenedPosition(w_j.pos, weight);
        }
        if (time == w.time) {
            return w.pos;
        }
        if (time < w.time) {
            return this.binarySearch(i, median, time);
        }
        return this.binarySearch(median, j, time);
    }

    public static boolean sameBuilding(Building[] buildings, Position pos1, Position pos2, Dimension dim) {
        int i = 0;
        if (i < buildings.length) {
            Building building = buildings[i];
            if (building.isInside(pos1, dim)) {
                if (building.isInside(pos2, dim)) {
                    return true;
                }
                return building.canCommunicateThroughDoor(pos1, pos2, dim);
            }
            return building.isInside(pos2, dim) && building.canCommunicateThroughDoor(pos2, pos1, dim);
        }
        return true;
    }

    public static double[] pairStatistics(MobileNode node1, MobileNode node2, double start, double duration, double range, boolean calculateMobility, Dimension dim) {
        return MobileNode.pairStatistics(node1, node2, start, duration, range, calculateMobility, new Building[0], dim);
    }

    public static double[] pairStatistics(MobileNode _node1, MobileNode _node2, double start, double duration, double range, boolean calculateMobility, Building[] buildings, Dimension dim) {
        MobileNode node1 = _node1;
        MobileNode node2 = _node2;
        double[] ch1 = node1.changeTimes();
        double[] ch2 = node2.changeTimes();
        Vector<Double> changes = new Vector<Double>();
        int i1 = 0;
        int i2 = 0;
        double t0 = start;
        Position o1 = node1.positionAt(start);
        Position o2 = node2.positionAt(start);
        double mobility = 0.0;
        double on_time = 0.0;
        double D_spatial = 0.0;
        int D_spatial_count = 0;
        boolean connected = false;
        boolean nodes_on_before = false;
        double Relative_speed = 0.0;
        int Relative_speed_count = 0;
        while (t0 < duration) {
            boolean nodes_on;
            double t1 = i1 < ch1.length ? (i2 < ch2.length ? (ch1[i1] < ch2[i2] ? ch1[i1++] : ch2[i2++]) : ch1[i1++]) : (i2 < ch2.length ? ch2[i2++] : duration);
            if (t1 > duration) {
                t1 = duration;
            }
            if (!(t1 > t0)) continue;
            Position n1 = node1.positionAt(t1);
            Position n2 = node2.positionAt(t1);
            boolean conn_t0 = o1.distance(o2) <= range && MobileNode.sameBuilding(buildings, o1, o2, dim);
            boolean conn_t1 = n1.distance(n2) <= range && MobileNode.sameBuilding(buildings, n1, n2, dim);
            boolean bl = nodes_on = o1.status != 2.0 && o2.status != 2.0;
            if (!connected && conn_t0 && nodes_on) {
                changes.addElement(t0);
                connected = true;
                if (t0 != start && nodes_on_before) {
                    System.out.println("MobileNode.pairStatistics: fp correction 1: connect at " + t0);
                }
            }
            if (connected && conn_t0 && !nodes_on) {
                changes.addElement(t0);
                connected = false;
            }
            double dt = t1 - t0;
            double dxo = o1.x - o2.x;
            double dxn = n1.x - n2.x;
            double dyo = o1.y - o2.y;
            double dyn = n1.y - n2.y;
            double dzo = o1.z - o2.z;
            double dzn = n1.z - n2.z;
            double c1 = (dxn - dxo) / dt;
            double c0 = (dxo * t1 - dxn * t0) / dt;
            double d1 = (dyn - dyo) / dt;
            double d0 = (dyo * t1 - dyn * t0) / dt;
            double e1 = (dzn - dzo) / dt;
            double e0 = (dzo * t1 - dzn * t0) / dt;
            if (o1.distance(o2) < 2.0 * range) {
                Position relative_vector;
                double RS;
                Position v_i = Position.diff(o1, n1);
                Position v_j = Position.diff(o2, n2);
                double s_i = Math.sqrt(Position.scalarProduct(v_i, v_i));
                double s_j = Math.sqrt(Position.scalarProduct(v_j, v_j));
                if (s_i > 0.0 && s_j > 0.0) {
                    double RD = Position.scalarProduct(v_i, v_j) / (s_i * s_j);
                    double SR = s_i > s_j ? s_j / s_i : s_i / s_j;
                    D_spatial += RD * SR;
                    if (RD * SR != 0.0) {
                        ++D_spatial_count;
                    }
                }
                if (Math.abs(RS = (relative_vector = Position.diff(v_i, v_j)).norm()) > 1.0E-7) {
                    Relative_speed += RS;
                    ++Relative_speed_count;
                }
            }
            if (nodes_on) {
                on_time += dt;
            }
            if (c1 != 0.0 || d1 != 0.0 || e1 != 0.0) {
                double q;
                double m2;
                double m = -1.0 * (c0 * c1 + d0 * d1 + e0 * e1) / (c1 * c1 + d1 * d1 + e1 * e1);
                double relmob = 0.0;
                if (calculateMobility && nodes_on) {
                    double dOld = Math.sqrt(dxo * dxo + dyo * dyo + dzo * dzo);
                    double dNew = Math.sqrt(dxn * dxn + dyn * dyn + dzo * dzo);
                    if (m > t0 && m < t1) {
                        Position in1 = node1.positionAt(m);
                        Position in2 = node2.positionAt(m);
                        double dInt = in2.distance(in1);
                        relmob = (Math.abs(dInt - dOld) + Math.abs(dNew - dInt)) / dt;
                    } else {
                        relmob = Math.abs(dNew - dOld) / dt;
                    }
                    mobility += relmob;
                }
                if ((m2 = m * m) - (q = (c0 * c0 + d0 * d0 + e0 * e0 - range * range) / (c1 * c1 + d1 * d1 + e1 * e1)) > 0.0) {
                    double d = Math.sqrt(m2 - q);
                    double min = m - d;
                    double max = m + d;
                    if (min >= t0 && min <= t1 && MobileNode.sameBuilding(buildings, o1, o2, dim)) {
                        if (d < 0.01) {
                            System.out.println("---------------");
                            System.out.println("MobileNode.pairStatistics: The time span these 2 nodes are in range seems very");
                            System.out.println("  short. Might this be an error or a bad choice of parameters?");
                            System.out.println("o1=" + o1);
                            System.out.println("n1=" + n1);
                            System.out.println("o2=" + o2);
                            System.out.println("n2=" + n2);
                            System.out.println("[" + t0 + ";" + t1 + "]:[" + m + "-" + d + "=" + min + ";" + m + "+" + d + "=" + max + "]");
                            System.out.println("---------------");
                        }
                        if (nodes_on) {
                            if (!connected) {
                                changes.addElement(min);
                                connected = true;
                            } else if (min - t0 > 0.001) {
                                System.out.println("MobileNode.pairStatistics: sanity check failed (1)");
                                System.exit(0);
                            } else {
                                System.out.println("MobileNode.pairStatistics: connect too late: t=" + min + " t0=" + t0);
                            }
                        }
                    }
                    if (max >= t0 && max <= t1 && MobileNode.sameBuilding(buildings, o1, o2, dim) && nodes_on) {
                        if (connected) {
                            changes.addElement(max);
                            connected = false;
                        } else if (t0 - min < 0.001 && max - t0 > 0.001) {
                            changes.addElement(t0);
                            changes.addElement(max);
                        } else if (max - t0 > 0.001) {
                            System.out.println("MobileNode.pairStatistics: sanity check failed (2)");
                            System.out.println("t0: " + t0 + ", t1: " + t1);
                            System.out.println("min: " + min + ", d: " + d + ", max: " + max);
                            System.out.println("last disconnect at " + changes.lastElement());
                            System.out.println("n1 (t0): " + node1.positionAt(t0).toString() + ", n2 (t0): " + node2.positionAt(t0).toString());
                            System.out.println("dist: " + node1.positionAt(t0).distance(node2.positionAt(t0)));
                            System.out.println("n1 (t1): " + node1.positionAt(t1).toString() + ", n2 (t1): " + node2.positionAt(t1).toString());
                            System.out.println("dist: " + node1.positionAt(t1).distance(node2.positionAt(t1)));
                            System.exit(0);
                        } else {
                            System.out.println("MobileNode.pairStatistics: disconnect too late: t=" + max + " t0=" + t0);
                        }
                    }
                }
            }
            t0 = t1;
            o1 = n1;
            o2 = n2;
            nodes_on_before = nodes_on;
            if (connected) {
                if (conn_t1) continue;
                changes.addElement(t1);
                connected = false;
                System.out.println("MobileNode.pairStatistics: fp correction 2: disconnect at " + t1);
                continue;
            }
            if (!conn_t1 || !nodes_on) continue;
            changes.addElement(t1);
            connected = true;
            System.out.println("MobileNode.pairStatistics: fp correction 3: connect at " + t1);
        }
        if (connected) {
            changes.addElement(duration);
        }
        double[] result = new double[changes.size() + 6];
        for (int i = 0; i < result.length; ++i) {
            if (i == 0) {
                result[i] = mobility;
                result[i + 1] = on_time;
                result[i + 2] = D_spatial;
                result[i + 3] = D_spatial_count;
                result[i + 4] = Relative_speed;
                result[i + 5] = Relative_speed_count;
                i += 5;
                continue;
            }
            result[i] = (Double)changes.elementAt(i - 6);
        }
        return result;
    }

    public static double[] getDegreeOfTemporalDependence(MobileNode _node, double start, double end, double c) {
        MobileNode node = _node;
        double[] temporal_dependence = new double[2];
        double[] change_times = node.changeTimes();
        double temp_dependence = 0.0;
        int temporal_dependence_count = 0;
        for (int i = 0; i < change_times.length - 1; ++i) {
            for (int j = i + 1; j < change_times.length - 1; ++j) {
                double time_t_prime;
                double time_t;
                Position vector_t_prime;
                Position vector_t;
                double dependence;
                if (!(Math.abs(change_times[i] - change_times[j]) > c) || !(Math.abs(dependence = MobileNode.getDegreeOfDependence(vector_t = Position.diff(node.positionAt(change_times[i]), node.positionAt(change_times[i + 1])), vector_t_prime = Position.diff(node.positionAt(change_times[j]), node.positionAt(change_times[j + 1])), time_t = change_times[i + 1] - change_times[i], time_t_prime = change_times[j + 1] - change_times[j])) > 1.0E-7)) continue;
                temp_dependence += dependence;
                ++temporal_dependence_count;
            }
        }
        temporal_dependence[0] = temp_dependence;
        temporal_dependence[1] = temporal_dependence_count;
        return temporal_dependence;
    }

    public static double getDegreeOfDependence(Position _vector_i, Position _vector_j, double time_i, double time_j) {
        Position vector_i = _vector_i;
        Position vector_j = _vector_j;
        double dependence = 0.0;
        double speed_i = vector_i.norm() / time_i;
        double speed_j = vector_j.norm() / time_j;
        if (speed_i > 0.0 && speed_j > 0.0) {
            double RD = Position.scalarProduct(vector_i, vector_j) / (vector_i.norm() * vector_j.norm());
            double SR = speed_i > speed_j ? speed_j / speed_i : speed_i / speed_j;
            dependence = RD * SR;
        }
        return dependence;
    }

    public static double[] getConnectionTime(MobileNode node1, MobileNode node2, double start, double duration, double range, Dimension dim) {
        return MobileNode.getConnectionTime(node1, node2, start, duration, range, new Building[0], dim);
    }

    public static double[] getConnectionTime(MobileNode _node1, MobileNode _node2, double start, double duration, double range, Building[] buildings, Dimension dim) {
        MobileNode node1 = _node1;
        MobileNode node2 = _node2;
        double[] ch1 = node1.changeTimes();
        double[] ch2 = node2.changeTimes();
        double on_time = 0.0;
        double con_time = 0.0;
        double link_up_at = 0.0;
        int i1 = 0;
        int i2 = 0;
        double t0 = start;
        Position o1 = node1.positionAt(start);
        Position o2 = node2.positionAt(start);
        boolean connected = false;
        while (t0 < duration) {
            double q;
            double m;
            double m2;
            boolean nodes_on;
            double t1 = i1 < ch1.length ? (i2 < ch2.length ? (ch1[i1] < ch2[i2] ? ch1[i1++] : ch2[i2++]) : ch1[i1++]) : (i2 < ch2.length ? ch2[i2++] : duration);
            if (t1 > duration) {
                t1 = duration;
            }
            if (!(t1 > t0)) continue;
            Position n1 = node1.positionAt(t1);
            Position n2 = node2.positionAt(t1);
            boolean conn_t0 = o1.distance(o2) <= range && MobileNode.sameBuilding(buildings, o1, o2, dim);
            boolean conn_t1 = n1.distance(n2) <= range && MobileNode.sameBuilding(buildings, n1, n2, dim);
            boolean bl = nodes_on = o1.status != 2.0 && o2.status != 2.0;
            if (!connected && conn_t0 && nodes_on) {
                link_up_at = t0;
                connected = true;
            }
            if (connected && conn_t0 && !nodes_on) {
                con_time += t0 - link_up_at;
                connected = false;
            }
            double dt = t1 - t0;
            double dxo = o1.x - o2.x;
            double dxn = n1.x - n2.x;
            double dyo = o1.y - o2.y;
            double dyn = n1.y - n2.y;
            double dzo = o1.z - o2.z;
            double dzn = n1.z - n2.z;
            double c1 = (dxn - dxo) / dt;
            double c0 = (dxo * t1 - dxn * t0) / dt;
            double d1 = (dyn - dyo) / dt;
            double d0 = (dyo * t1 - dyn * t0) / dt;
            double e1 = (dzn - dzo) / dt;
            double e0 = (dzo * t1 - dzn * t0) / dt;
            if (nodes_on) {
                on_time += dt;
            }
            if ((c1 != 0.0 || d1 != 0.0 || e1 != 0.0) && (m2 = (m = -1.0 * (c0 * c1 + d0 * d1 + e0 * e1) / (c1 * c1 + d1 * d1 + e1 * e1)) * m) - (q = (c0 * c0 + d0 * d0 + e0 * e0 - range * range) / (c1 * c1 + d1 * d1 + e1 * e1)) > 0.0) {
                double d = Math.sqrt(m2 - q);
                double min = m - d;
                double max = m + d;
                if (min >= t0 && min <= t1 && MobileNode.sameBuilding(buildings, o1, o2, dim)) {
                    if (d < 0.01) {
                        System.out.println("---------------");
                        System.out.println("MobileNode.pairStatistics: The time span these 2 nodes are in range seems very");
                        System.out.println("  short. Might this be an error or a bad choice of parameters?");
                        System.out.println("o1=" + o1);
                        System.out.println("n1=" + n1);
                        System.out.println("o2=" + o2);
                        System.out.println("n2=" + n2);
                        System.out.println("[" + t0 + ";" + t1 + "]:[" + m + "-" + d + "=" + min + ";" + m + "+" + d + "=" + max + "]");
                        System.out.println("---------------");
                    }
                    if (nodes_on) {
                        if (!connected) {
                            link_up_at = min;
                            connected = true;
                        } else if (min - t0 > 0.001) {
                            System.out.println("MobileNode.pairStatistics: sanity check failed (1)");
                            System.exit(0);
                        } else {
                            System.out.println("MobileNode.pairStatistics: connect too late: t=" + min + " t0=" + t0);
                        }
                    }
                }
                if (max >= t0 && max <= t1 && MobileNode.sameBuilding(buildings, o1, o2, dim) && nodes_on) {
                    if (connected) {
                        con_time += max - link_up_at;
                        connected = false;
                    } else if (max - t0 > 0.001) {
                        System.out.println("MobileNode.pairStatistics: sanity check failed (2)");
                        System.exit(0);
                    } else {
                        System.out.println("MobileNode.pairStatistics: disconnect too late: t=" + max + " t0=" + t0);
                    }
                }
            }
            t0 = t1;
            o1 = n1;
            o2 = n2;
            if (connected) {
                if (conn_t1) continue;
                con_time += t1 - link_up_at;
                connected = false;
                System.out.println("MobileNode.pairStatistics: fp correction 2: disconnect at " + t1);
                continue;
            }
            if (!conn_t1 || !nodes_on) continue;
            link_up_at = t1;
            connected = true;
            System.out.println("MobileNode.pairStatistics: fp correction 3: connect at " + t1);
        }
        if (connected) {
            con_time += duration - link_up_at;
        }
        double[] result = new double[]{on_time, con_time};
        return result;
    }

    public static double[] getSpeedoverTime(MobileNode _node, double start, double end, double interval) {
        int i;
        MobileNode node = _node;
        int size = (int)((end - start) / interval + 1.0);
        double[] speed = new double[2 * size];
        double[] cht = node.changeTimes();
        double[] dist_cht = new double[cht.length];
        boolean[] on_cht = new boolean[cht.length];
        double[] time_cht = new double[cht.length];
        double[] time_start = new double[cht.length];
        double t0 = start;
        Position p0 = node.positionAt(start);
        for (i = 0; i < cht.length; ++i) {
            double dp;
            double t1 = cht[i];
            double dt = t1 - t0;
            Position p1 = node.positionAt(t1);
            dist_cht[i] = dp = p0.distance(p1);
            on_cht[i] = p0.status != 2.0;
            time_cht[i] = dt;
            time_start[i] = t0;
            t0 = t1;
            p0 = p1;
        }
        i = 0;
        for (int j = 0; j < size; ++j) {
            int k = 0;
            while (time_start.length > i + k && time_start[i + k] < start + (double)(j + 1) * interval) {
                ++k;
            }
            double on_time = 0.0;
            double dist_on = 0.0;
            for (int i_run = i; i_run < i + k; ++i_run) {
                if (!on_cht[i_run]) continue;
                double help = time_cht[i_run];
                double help_dist = dist_cht[i_run];
                if (time_start[i_run] < start + (double)j * interval) {
                    help -= start + (double)j * interval - time_start[i_run];
                }
                if (time_start[i_run] + time_cht[i_run] > start + (double)(j + 1) * interval) {
                    help -= time_start[i_run] + time_cht[i_run] - (start + (double)(j + 1) * interval);
                }
                help_dist -= (1.0 - help / time_cht[i_run]) * help_dist;
                on_time += help;
                dist_on += help_dist;
            }
            speed[2 * j] = dist_on;
            speed[2 * j + 1] = on_time;
            i = i + k - 1;
        }
        return speed;
    }

    public static double getNodesOnTime(MobileNode node, double duration) {
        double[] cht = node.changeTimes();
        double on_time = 0.0;
        double t0 = 0.0;
        Position p0 = node.positionAt(t0);
        for (int i = 0; i < cht.length; ++i) {
            double t1 = cht[i];
            double dt = t1 - t0;
            Position p1 = node.positionAt(t1);
            if (p0.status != 2.0) {
                on_time += dt;
            }
            t0 = t1;
            p0 = p1;
        }
        return on_time += duration - t0;
    }

    public static boolean isNodeOffAtTime(MobileNode node, double time) {
        Position pos = node.positionAt(time);
        return pos.status == 2.0;
    }

    public static double[] getOnOffChanges(MobileNode node) {
        double[] ch = node.changeTimes();
        boolean on = true;
        int events = 0;
        for (int t = 0; t < ch.length; ++t) {
            if (!(node.positionAt((double)ch[t]).status > 0.0)) continue;
            ++events;
        }
        double[] result = new double[events];
        int j = 0;
        for (int t = 0; t < ch.length; ++t) {
            if (node.positionAt((double)ch[t]).status == 2.0) {
                result[j] = ch[t];
                ++j;
                on = false;
            }
            if (node.positionAt((double)ch[t]).status != 1.0) continue;
            result[j] = ch[t];
            ++j;
            if (on) {
                System.err.println("Error: Node switches on, but is already switched on! (t=" + ch[t] + ")");
            }
            on = true;
        }
        return result;
    }
}

