/*
 * Decompiled with CFR 0.152.
 */
package bonnmotion;

import bonnmotion.Position;
import java.util.Vector;

public class AttractorField {
    protected Vector<Attractor> attractors = new Vector();
    protected double lTotal = 0.0;
    protected final double x;
    protected final double y;

    public AttractorField(double x, double y) {
        this.x = x;
        this.y = y;
    }

    public void add(Position attractor, double level, double stdDev) {
        this.attractors.addElement(new Attractor(attractor, level, stdDev));
        this.lTotal += level;
    }

    public void add(Position attractor, double level, double stdDev, double stdDev2) {
        this.attractors.addElement(new Attractor(attractor, level, stdDev, stdDev2));
        this.lTotal += level;
    }

    public void add(double[] param) {
        for (int p = 0; p < param.length; p += 5) {
            if (param.length - p >= 5) {
                this.add(new Position(param[p], param[p + 1]), param[p + 2], param[p + 3], param[p + 4]);
                continue;
            }
            System.out.println("warning: attraction field argument list has wrong number of elements!");
        }
    }

    public Position getPosJunk(double rndUniform1, double rndUniform2, double rndGaussian) {
        double s;
        double r = rndUniform1 * this.lTotal;
        Attractor a = null;
        int i = 0;
        for (s = 0.0; i < this.attractors.size() && r >= s; s += a.level) {
            a = this.attractors.elementAt(i++);
        }
        if (r >= s || a == null) {
            System.out.println("AttractorField.getPos: Somethings going wrong here");
            System.exit(0);
        }
        double dir = Math.PI * rndUniform2;
        double dist = rndGaussian * a.stdDev;
        Position rVal = new Position(a.pos.x + Math.cos(dir) * dist, a.pos.y + Math.sin(dir) * dist);
        if (rVal.x >= 0.0 && rVal.y >= 0.0 && rVal.x <= this.x && rVal.y <= this.y) {
            return rVal;
        }
        return null;
    }

    public Position getPos(double rndUniform, double rndGaussian1, double rndGaussian2) {
        double s;
        double r = rndUniform * this.lTotal;
        Attractor a = null;
        int i = 0;
        for (s = 0.0; i < this.attractors.size() && r >= s; s += a.level) {
            a = this.attractors.elementAt(i++);
        }
        if (r >= s || a == null) {
            System.out.println("AttractorField.getPos: Somethings going wrong here");
            System.exit(0);
        }
        Position rVal = new Position(a.pos.x + rndGaussian1 * a.stdDev, a.pos.y + rndGaussian2 * a.stdDev2);
        if (rVal.x >= 0.0 && rVal.y >= 0.0 && rVal.x <= this.x && rVal.y <= this.y) {
            return rVal;
        }
        return null;
    }

    class Attractor {
        public final Position pos;
        public final double level;
        public final double stdDev;
        public final double stdDev2;

        public Attractor(Position pos, double level, double stdDev) {
            this.pos = pos;
            this.level = level;
            this.stdDev = stdDev;
            this.stdDev2 = stdDev;
        }

        public Attractor(Position pos, double level, double stdDev, double stdDev2) {
            this.pos = pos;
            this.level = level;
            this.stdDev = stdDev;
            this.stdDev2 = stdDev2;
        }
    }
}

